<?php
require_once __DIR__ . '/core/init.php';
require_once __DIR__ . '/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setTitle('Template Nhap San Pham');

// Đã xóa cột Tồn kho (prd_inventory)
$sheet->setCellValue('A1', 'Tên sản phẩm (*)');
$sheet->setCellValue('B1', 'Mã sản phẩm (Bỏ trống sẽ tự sinh)');
$sheet->setCellValue('C1', 'Giá vốn');
$sheet->setCellValue('D1', 'Giá bán lẻ (*)');
$sheet->setCellValue('E1', 'Giá bán sỉ');
$sheet->setCellValue('F1', 'Tên Danh mục (Phải có sẵn trong hệ thống)');
$sheet->setCellValue('G1', 'Tên Nhà sản xuất (Phải có sẵn)');
$sheet->setCellValue('H1', 'Tên Đơn vị tính (Phải có sẵn)');
$sheet->setCellValue('I1', 'Tên quy cách (Vd: Thùng, Lốc)');
$sheet->setCellValue('J1', 'Quy cách (Vd: 24)');

$sheet->getStyle('A1:J1')->getFont()->setBold(true);

foreach (range('A', 'J') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="template_import_sanpham.xlsx"');
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
?>