<?php
require_once __DIR__ . '/../core/init.php';
header('Content-Type: application/json; charset=utf-8');

$action = $_POST['action'] ?? '';

if ($action == 'save_config') {
    // 1. LƯU CẤU HÌNH LƯƠNG
    $id = intval($_POST['user_id']);
    $salary = floatval($_POST['salary_base']);
    $allowance = floatval($_POST['allowance']);
    $commission = floatval($_POST['commission']);
    $phone = $_POST['phone'];
    $bank_name = $_POST['bank_name'];
    $bank_acc = $_POST['bank_account'];

    $stmt = $conn->prepare("UPDATE cms_users SET salary_base=?, allowance=?, commission=?, phone=?, bank_name=?, bank_account=? WHERE id=?");
    $stmt->bind_param("dddsssi", $salary, $allowance, $commission, $phone, $bank_name, $bank_acc, $id);
    
    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Đã lưu cấu hình lương!']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Lỗi: ' . $conn->error]);
    }
} 
else if ($action == 'calculate') {
    // 2. TÍNH TOÁN BẢNG LƯƠNG
    $month_str = $_POST['month']; // YYYY-MM
    $user_id = $_POST['user_id'];
    
    // Tách tháng năm
    list($year, $month) = explode('-', $month_str);

    // Điều kiện lọc nhân viên
    $user_cond = ($user_id != 'all') ? "AND id = ".intval($user_id) : "";

    // Lấy danh sách nhân viên cần tính
    $sql_users = "SELECT * FROM cms_users WHERE user_status = 1 $user_cond";
    $users = $conn->query($sql_users)->fetch_all(MYSQLI_ASSOC);

    $payroll_data = [];

    foreach ($users as $u) {
        // Lấy tổng doanh số và tiền vốn của nhân viên trong tháng
        // Giả sử bảng cms_orders có user_init là người tạo đơn (người bán) và order_status = 1 là đơn thành công
        $sql_sales = "SELECT 
                        SUM(total_money) as total_sales, 
                        SUM(total_origin_price) as total_cost 
                      FROM cms_orders 
                      WHERE user_init = {$u['id']} 
                      AND order_status = 1 
                      AND MONTH(sell_date) = $month 
                      AND YEAR(sell_date) = $year";
        
        $sales_data = $conn->query($sql_sales)->fetch_assoc();
        
        $total_sales = floatval($sales_data['total_sales'] ?? 0);
        $total_cost = floatval($sales_data['total_cost'] ?? 0);
        
        // 1. Tính Lợi nhuận
        $profit = $total_sales - $total_cost;
        if($profit < 0) $profit = 0; // Tránh lợi nhuận âm nếu có sai sót dữ liệu

        // 2. Tính tiền hoa hồng: Lợi nhuận * % hoa hồng
        $commission_money = $profit * ($u['commission'] / 100);

        // 3. Tổng lương = Lương cứng + Phụ cấp + Hoa hồng
        $total_salary = $u['salary_base'] + $u['allowance'] + $commission_money;

        $payroll_data[] = [
            'name' => $u['display_name'],
            'bank_name' => $u['bank_name'],
            'bank_account' => $u['bank_account'],
            'salary_base' => $u['salary_base'],
            'allowance' => $u['allowance'],
            'sales' => $total_sales,
            'profit' => $profit,
            'commission_rate' => $u['commission'],
            'commission_money' => $commission_money,
            'total_salary' => $total_salary
        ];
    }

    echo json_encode(['status' => 'success', 'data' => $payroll_data]);
}
?>