<?php
// Đường dẫn: quanlybanhang/ajax/printer_ajax.php

// 1. Kết nối Database
if (file_exists(__DIR__ . '/../core/helpers.php')) {
    require_once __DIR__ . '/../core/helpers.php';
} else {
    // Fallback nếu không tìm thấy helpers (để tránh lỗi)
    $conn = new mysqli("localhost", "root", "", "quanlybanhang_db");
    if ($conn->connect_error) {
        die(json_encode(['status' => 'error', 'message' => 'Lỗi kết nối DB: ' . $conn->connect_error]));
    }
}

header('Content-Type: application/json');

$action = $_POST['action'] ?? '';

// --- CHỨC NĂNG 1: QUÉT MẠNG LAN (Theo dải 192.168.107.x) ---
if ($action == 'scan_network') {
    // Cấu hình dải mạng của bạn
    $subnet = '192.168.107'; 
    $start_ip = 2;   // Bắt đầu từ .2
    $end_ip   = 254; // Kết thúc ở .254
    
    $found_devices = [];
    $port = 9100; // Cổng in mặc định

    // Vòng lặp quét
    for ($i = $start_ip; $i <= $end_ip; $i++) {
        $ip = "$subnet.$i";
        
        // Timeout cực thấp (0.1s) để quét nhanh qua các IP không tồn tại
        $fp = @fsockopen($ip, $port, $errno, $errstr, 0.1);
        
        if ($fp) {
            fclose($fp);
            $found_devices[] = ['ip' => $ip];
        }
    }
    
    echo json_encode(['status' => 'success', 'data' => $found_devices]);
    exit;
}

// --- CHỨC NĂNG 2: THÊM MÁY IN VÀO CSDL ---
if ($action == 'add_printer') {
    $ip = $_POST['ip'];
    $name = $_POST['name'];
    
    // Kiểm tra xem IP này đã thêm chưa
    $check = $conn->query("SELECT id FROM pos_printers WHERE ip_address = '$ip'");
    if ($check && $check->num_rows > 0) {
        echo json_encode(['status' => 'error', 'message' => 'Máy in IP này đã có trong danh sách!']);
        exit;
    }
    
    // Insert
    $stmt = $conn->prepare("INSERT INTO pos_printers (printer_name, ip_address) VALUES (?, ?)");
    $stmt->bind_param("ss", $name, $ip);
    
    if ($stmt->execute()) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Lỗi SQL: ' . $conn->error]);
    }
    exit;
}

// --- CHỨC NĂNG 3: XÓA MÁY IN ---
if ($action == 'delete_printer') {
    $id = intval($_POST['id']);
    $conn->query("DELETE FROM pos_printers WHERE id = $id");
    echo json_encode(['status' => 'success']);
    exit;
}

// --- CHỨC NĂNG 4: IN TEST ---
if ($action == 'test_print') {
    $ip = $_POST['ip'];
    $port = 9100;
    
    try {
        $fp = @fsockopen($ip, $port, $errno, $errstr, 2); // Timeout 2s cho lệnh in
        if (!$fp) {
            echo json_encode(['status' => 'error', 'message' => "Không kết nối được tới $ip ($errstr)"]);
            exit;
        }
        
        // Lệnh ESC/POS test
        $content = "\x1b\x40"; // Init
        $content .= "\x1b\x61\x01"; // Center
        $content .= "TEST KET NOI THANH CONG!\n";
        $content .= "IP: $ip\n";
        $content .= "System Ready.\n\n\n\n";
        $content .= "\x1d\x56\x00"; // Cut paper
        
        fwrite($fp, $content);
        fclose($fp);
        
        echo json_encode(['status' => 'success', 'message' => 'Đã gửi lệnh in thành công!']);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}
?>