<?php
require_once __DIR__ . '/../core/init.php';

// Mảng để chứa kết quả
$results = [];

// jQuery UI Autocomplete gửi từ khóa tìm kiếm qua tham số 'term'
if (isset($_GET['term'])) {
    $searchTerm = trim($_GET['term']);
    
    // Tìm kiếm các sản phẩm có tên LIKE với từ khóa
    if (!empty($searchTerm)) {
        $searchTermWildcard = "%" . $searchTerm . "%";
        $sql = "SELECT prd_name FROM cms_products WHERE prd_name LIKE ? LIMIT 10";
        
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $searchTermWildcard);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                // Thêm mỗi tên sản phẩm vào mảng kết quả
                $results[] = $row['prd_name'];
            }
        }
        $stmt->close();
    }
}

// Trả về kết quả dưới dạng JSON
header('Content-Type: application/json');
echo json_encode($results);
$conn->close();
?>