<?php
require_once __DIR__ . '/../core/init.php';
header('Content-Type: application/json; charset=utf-8');

if (session_status() == PHP_SESSION_NONE) { session_start(); }

$action = $_REQUEST['action'] ?? '';
$type = $_REQUEST['type'] ?? '';
$response = ['status' => 'error', 'message' => 'Hành động không hợp lệ.'];

$table_map = [
    'category' => ['table' => 'cms_products_group', 'name_col' => 'prd_group_name'],
    'manufacturer' => ['table' => 'cms_products_manufacture', 'name_col' => 'prd_manuf_name'],
    'unit' => ['table' => 'cms_products_unit', 'name_col' => 'prd_unit_name']
];

if (!isset($table_map[$type])) { echo json_encode($response); exit; }

$table_info = $table_map[$type];
$table_name = $table_info['table'];
$name_col = $table_info['name_col'];

if ($action == 'get_list') {
    $result = $conn->query("SELECT id, $name_col as name FROM $table_name ORDER BY name ASC");
    $data = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];
    echo json_encode(['status' => 'success', 'data' => $data]);
    exit;
}

if ($action == 'add') {
    $name = trim($_POST['name'] ?? '');
    if (empty($name)) { echo json_encode(['status' => 'error', 'message' => 'Tên không được để trống.']); exit; }
    $stmt = $conn->prepare("INSERT INTO $table_name ($name_col) VALUES (?)");
    $stmt->bind_param("s", $name);
    if ($stmt->execute()) {
        $new_id = $stmt->insert_id;
        $response = ['status' => 'success', 'message' => 'Thêm mới thành công!', 'new_item' => ['id' => $new_id, 'name' => $name]];
    } else { $response['message'] = 'Lỗi CSDL: ' . $stmt->error; }
    $stmt->close();
    echo json_encode($response);
    exit;
}

if ($action == 'update') {
    $id = intval($_POST['id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    if (empty($id) || empty($name)) { echo json_encode(['status' => 'error', 'message' => 'Dữ liệu không hợp lệ.']); exit; }
    $stmt = $conn->prepare("UPDATE $table_name SET $name_col = ? WHERE id = ?");
    $stmt->bind_param("si", $name, $id);
    if ($stmt->execute()) { $response = ['status' => 'success', 'message' => 'Cập nhật thành công!']; }
    else { $response = ['status' => 'error', 'message' => 'Lỗi khi cập nhật.']; }
    $stmt->close();
    echo json_encode($response);
    exit;
}

if ($action == 'delete') {
    $id = intval($_POST['id'] ?? 0);
    if ($id <= 0) { echo json_encode(['status' => 'error', 'message' => 'ID không hợp lệ.']); exit; }
    $stmt = $conn->prepare("DELETE FROM $table_name WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) { $response = ['status' => 'success', 'message' => 'Xóa thành công!']; }
    else { $response = ['status' => 'error', 'message' => 'Lỗi khi xóa. Đối tượng này có thể đang được sử dụng.']; }
    $stmt->close();
    echo json_encode($response);
    exit;
}
?>