<?php
ini_set('display_errors', 0);
error_reporting(E_ALL);

require_once __DIR__ . '/../config/database.php';
header('Content-Type: application/json; charset=utf-8');

if (session_status() === PHP_SESSION_NONE) { session_start(); }

$store_id = $_SESSION['store_id'] ?? 1;
$action = $_REQUEST['action'] ?? '';

try {
    switch ($action) {
        case 'get_areas': handle_get_areas($conn, $store_id); break;
        case 'save_area': handle_save_area($conn, $store_id); break;
        case 'delete_area': handle_delete_area($conn); break;
        case 'get_tables': handle_get_tables($conn, $store_id); break;
        case 'save_table': handle_save_table($conn, $store_id); break;
        case 'delete_table': handle_delete_table($conn); break;
        default: echo json_encode(['status' => 'error', 'message' => 'Hành động không hợp lệ']); break;
    }
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Lỗi Server: ' . $e->getMessage()]);
}

// --- KHU VỰC ---
function handle_get_areas($conn, $store_id) {
    $sql = "SELECT * FROM cms_areas WHERE store_id = ? AND deleted = 0 ORDER BY id ASC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $store_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = [];
    while ($row = $result->fetch_assoc()) { $data[] = $row; }
    echo json_encode(['status' => 'success', 'data' => $data]);
}

function handle_save_area($conn, $store_id) {
    $id = intval($_POST['area_id'] ?? 0);
    $name = trim($_POST['area_name'] ?? '');
    
    if (empty($name)) { echo json_encode(['status' => 'error', 'message' => 'Tên khu vực không được để trống']); return; }

    // KIỂM TRA TRÙNG TÊN KHU VỰC
    $check_sql = "SELECT id FROM cms_areas WHERE area_name = ? AND store_id = ? AND deleted = 0 AND id != ?";
    $check = $conn->prepare($check_sql);
    $check->bind_param("sii", $name, $store_id, $id);
    $check->execute();
    if ($check->get_result()->num_rows > 0) {
        echo json_encode(['status' => 'error', 'message' => 'Tên khu vực đã tồn tại!']); return;
    }

    if ($id > 0) {
        $stmt = $conn->prepare("UPDATE cms_areas SET area_name = ? WHERE id = ? AND store_id = ?");
        $stmt->bind_param("sii", $name, $id, $store_id);
    } else {
        $stmt = $conn->prepare("INSERT INTO cms_areas (area_name, store_id) VALUES (?, ?)");
        $stmt->bind_param("si", $name, $store_id);
    }
    
    if ($stmt->execute()) { echo json_encode(['status' => 'success', 'message' => 'Lưu khu vực thành công']); }
    else { echo json_encode(['status' => 'error', 'message' => 'Lỗi DB: ' . $stmt->error]); }
}

function handle_delete_area($conn) {
    $id = intval($_POST['id'] ?? 0);
    $check = $conn->query("SELECT count(*) FROM cms_tables WHERE area_id = $id AND deleted = 0")->fetch_row()[0];
    if ($check > 0) { echo json_encode(['status' => 'error', 'message' => 'Không thể xóa khu vực đang chứa bàn.']); return; }
    
    $stmt = $conn->prepare("UPDATE cms_areas SET deleted = 1 WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) { echo json_encode(['status' => 'success', 'message' => 'Đã xóa khu vực']); }
    else { echo json_encode(['status' => 'error', 'message' => 'Lỗi DB']); }
}

// --- BÀN ---
function handle_get_tables($conn, $store_id) {
    $area_id = intval($_GET['area_id'] ?? 0);
    $where = "t.store_id = $store_id AND t.deleted = 0";
    if ($area_id > 0) { $where .= " AND t.area_id = $area_id"; }
    
    $sql = "SELECT t.*, a.area_name FROM cms_tables t LEFT JOIN cms_areas a ON t.area_id = a.id WHERE $where ORDER BY t.area_id ASC, t.table_name ASC";
    $result = $conn->query($sql);
    
    if ($result) {
        $data = [];
        while ($row = $result->fetch_assoc()) { $data[] = $row; }
        echo json_encode(['status' => 'success', 'data' => $data]);
    } else { echo json_encode(['status' => 'error', 'message' => 'Lỗi truy vấn: ' . $conn->error]); }
}

function handle_save_table($conn, $store_id) {
    $id = intval($_POST['table_id'] ?? 0);
    $name = trim($_POST['table_name'] ?? '');
    $area_id = intval($_POST['area_id'] ?? 0);
    
    if (empty($name) || $area_id == 0) { echo json_encode(['status' => 'error', 'message' => 'Vui lòng nhập tên bàn và chọn khu vực']); return; }

    // KIỂM TRA TRÙNG TÊN BÀN (Trong cùng cửa hàng)
    // Nếu muốn cho phép trùng tên khác khu vực thì thêm điều kiện AND area_id = ? vào query
    $check_sql = "SELECT id FROM cms_tables WHERE table_name = ? AND store_id = ? AND deleted = 0 AND id != ?";
    $check = $conn->prepare($check_sql);
    $check->bind_param("sii", $name, $store_id, $id);
    $check->execute();
    
    if ($check->get_result()->num_rows > 0) {
        echo json_encode(['status' => 'error', 'message' => 'Tên bàn này đã tồn tại! Vui lòng chọn tên khác.']); 
        return;
    }

    if ($id > 0) {
        $stmt = $conn->prepare("UPDATE cms_tables SET table_name = ?, area_id = ? WHERE id = ? AND store_id = ?");
        $stmt->bind_param("siii", $name, $area_id, $id, $store_id);
    } else {
        $stmt = $conn->prepare("INSERT INTO cms_tables (table_name, area_id, store_id, table_status) VALUES (?, ?, ?, 0)");
        $stmt->bind_param("sii", $name, $area_id, $store_id);
    }
    
    if ($stmt->execute()) { echo json_encode(['status' => 'success', 'message' => 'Lưu bàn thành công']); }
    else { echo json_encode(['status' => 'error', 'message' => 'Lỗi DB: ' . $stmt->error]); }
}

function handle_delete_table($conn) {
    $id = intval($_POST['id'] ?? 0);
    $stmt = $conn->prepare("UPDATE cms_tables SET deleted = 1 WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) { echo json_encode(['status' => 'success', 'message' => 'Đã xóa bàn']); }
    else { echo json_encode(['status' => 'error', 'message' => 'Lỗi DB']); }
}
?>