<?php
ini_set('session.cookie_lifetime', 28800);
ini_set('session.gc_maxlifetime', 28800);
session_cache_expire(480);

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../config/database.php';

$public_pages = [
    'login.php',
    'process_login.php',
    'update_password.php'
];

$current_page = basename($_SERVER['PHP_SELF']);

if (!isset($_SESSION['user_id']) && !in_array($current_page, $public_pages)) {
    header('Location: /quanlybanhang/login.php');
    exit();
}
?>