<?php
require_once __DIR__ . '/core/init.php';

function get_true_latest_price($product_id, $conn) {
    // Sửa lại tìm kiếm theo ID dạng số để chính xác hơn
    $like_term = '%"id":' . $product_id . ',%';
    $like_term_end = '%"id":' . $product_id . '}%';

    $sql = "SELECT detail_input FROM cms_input 
            WHERE (detail_input LIKE ? OR detail_input LIKE ?) AND deleted = 0 
            ORDER BY id DESC";
    
    $stmt = $conn->prepare($sql);
    if (!$stmt) return null;

    $stmt->bind_param("ss", $like_term, $like_term_end);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $items = json_decode($row['detail_input'], true);
        if (is_array($items)) {
            foreach (array_reverse($items) as $item) {
                if (isset($item['id']) && $item['id'] == $product_id && isset($item['price'])) {
                    $stmt->close();
                    return floatval($item['price']);
                }
            }
        }
    }
    $stmt->close();
    return null;
}

$is_live_run = isset($_GET['run']) && $_GET['run'] === 'true';

echo "<style> body { font-family: sans-serif; padding: 20px; } table { border-collapse: collapse; width: 100%; margin: 20px auto; font-size: 14px; } th, td { border: 1px solid #ddd; padding: 8px; text-align: left; } th { background-color: #f2f2f2; } .container { max-width: 1200px; margin: auto; } .header { background-color: #e9ecef; padding: 20px; border-radius: 5px; margin-bottom: 20px;} .report { border: 1px solid #ccc; padding: 20px; } .action-button { font-size: 18px; padding: 10px 20px; color: white; background-color: #dc3545; border: none; border-radius: 5px; text-decoration: none; display: inline-block; margin-top: 20px; } .action-button.dry-run { background-color: #007bff; } .success { color: green; font-weight: bold; } .error { color: red; font-weight: bold; } .warning { color: orange; } .no-change { color: #6c757d; } </style>";
echo "<div class='container'>";
echo "<div class='header'><h1>Công Cụ Sửa Chữa Giá Vốn Bình Quân (Phiên bản Quét Toàn Diện)</h1>";
echo "<p>Kịch bản này sẽ quét toàn bộ sản phẩm có tồn kho và so sánh giá vốn hiện tại với giá nhập gần nhất trong lịch sử.</p>";
echo "<p><b>Quan trọng:</b> Công cụ này sẽ <b>KHÔNG THAY ĐỔI SỐ LƯỢNG TỒN KHO (`prd_sls`)</b> hiện tại của bạn.</p>";
echo "</div>";

try {
    // Bước 1: Lấy TẤT CẢ sản phẩm đang có tồn kho
    $sql_find_all_stock = "SELECT ID, prd_name, prd_sls, prd_average_cost FROM cms_products WHERE prd_sls > 0";
    
    $all_products_result = $conn->query($sql_find_all_stock);
    $all_products_with_stock = $all_products_result->fetch_all(MYSQLI_ASSOC);

    // Bước 2: Lặp qua từng sản phẩm để kiểm tra
    $products_to_fix = [];
    foreach ($all_products_with_stock as $product) {
        $true_latest_price = get_true_latest_price($product['ID'], $conn);
        
        // Điều kiện để sửa:
        // 1. Tìm thấy giá nhập trong lịch sử
        // 2. Giá vốn hiện tại khác giá nhập thực tế (sai số > 0.01 để bỏ qua lỗi làm tròn)
        if ($true_latest_price !== null && abs($product['prd_average_cost'] - $true_latest_price) > 0.01) {
             $product['true_latest_price'] = $true_latest_price;
             $products_to_fix[] = $product;
        }
    }

    echo "<div class='report'>";
    if (empty($products_to_fix)) {
        echo "<h2><span class='success'>Tuyệt vời!</span> Không tìm thấy sản phẩm nào có giá vốn cần sửa chữa.</h2>";
    } else {
        if (!$is_live_run) {
            echo "<h2>Chế độ Phân Tích (An toàn - Chưa cập nhật CSDL)</h2>";
            echo "<p>Tìm thấy <b>" . count($products_to_fix) . "</b> sản phẩm có giá vốn không khớp với lịch sử nhập hàng. Đề xuất cập nhật như sau:</p>";
            
            echo "<table><thead><tr><th>ID</th><th>Tên Sản Phẩm</th><th>Tồn Kho</th><th class='error'>GVBQ (Hiện tại)</th><th class='success'>GVBQ (Đề Xuất - theo lịch sử)</th></tr></thead><tbody>";
            foreach ($products_to_fix as $product) {
                echo "<tr>";
                echo "<td>" . $product['ID'] . "</td>";
                echo "<td>" . htmlspecialchars($product['prd_name']) . "</td>";
                echo "<td>" . number_format($product['prd_sls']) . "</td>";
                echo "<td class='error'>" . number_format($product['prd_average_cost'], 2) . "</td>";
                echo "<td class='success'>" . number_format($product['true_latest_price'], 2) . "</td>";
                echo "</tr>";
            }
            echo "</tbody></table>";
            echo "<p>Nếu bạn đồng ý, hãy sao lưu CSDL rồi nhấn vào nút bên dưới để thực hiện cập nhật.</p>";
            echo "<a href='?run=true' class='action-button' onclick='return confirm(\"Hành động này sẽ thay đổi dữ liệu trong CSDL! Bạn có chắc chắn muốn tiếp tục?\");'>CẬP NHẬT THEO GIÁ NHẬP THỰC TẾ</a>";
        } else {
            echo "<h2>Chế độ Thực Thi - Đang cập nhật CSDL...</h2>";
            
            $conn->begin_transaction();
            try {
                $stmt_update = $conn->prepare("UPDATE cms_products SET prd_total_value = ?, prd_average_cost = ?, prd_origin_price = ? WHERE ID = ?");
                $updated_count = 0;
                
                foreach ($products_to_fix as $product) {
                    $true_latest_price = $product['true_latest_price'];
                    $new_total_value = floatval($product['prd_sls']) * $true_latest_price;
                    $product_id = intval($product['ID']);
                    $stmt_update->bind_param("dddi", $new_total_value, $true_latest_price, $true_latest_price, $product_id);
                    $stmt_update->execute();
                    $updated_count++;
                }
                
                $stmt_update->close();
                $conn->commit();

                echo "<h3><span class='success'>THÀNH CÔNG!</span></h3>";
                echo "<p>Đã cập nhật lại giá trị kho và giá vốn bình quân cho <b>" . $updated_count . "</b> sản phẩm.</p>";
                echo "<a href='/quanlybanhang/modules/products/list.php' class='action-button dry-run'>Quay lại danh sách sản phẩm</a>";

            } catch (Exception $e) {
                $conn->rollback();
                throw $e;
            }
        }
    }
    echo "</div>";
} catch (Exception $e) {
    echo "<h2><span class='error'>ĐÃ CÓ LỖI XẢY RA!</span></h2>";
    echo "<p>Lỗi: " . htmlspecialchars($e->getMessage()) . "</p>";
}
echo "</div>";
?>