<?php require_once __DIR__ . '/../../templates/header.php'; ?>

<style>
    /* --- DASHBOARD STYLES --- */
    .summary-card {
        border: none; border-radius: 15px; overflow: hidden;
        box-shadow: 0 4px 20px rgba(0,0,0,0.05);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        color: #fff; height: 100%;
    }
    .summary-card:hover { transform: translateY(-5px); box-shadow: 0 8px 25px rgba(0,0,0,0.15); }
    
    .card-body-content { padding: 1.5rem; display: flex; justify-content: space-between; align-items: center; z-index: 2; position: relative; }
    
    /* Gradient Colors */
    .bg-gradient-primary { background: linear-gradient(45deg, #4e73df, #224abe); }
    .bg-gradient-success { background: linear-gradient(45deg, #1cc88a, #13855c); }
    .bg-gradient-info    { background: linear-gradient(45deg, #36b9cc, #258391); }
    .bg-gradient-warning { background: linear-gradient(45deg, #f6c23e, #dda20a); }
    .bg-gradient-danger  { background: linear-gradient(45deg, #e74a3b, #be2617); } /* Màu đỏ cho chi phí */
    .bg-gradient-purple  { background: linear-gradient(45deg, #6f42c1, #59359a); } /* Màu tím cho chi tháng */

    .text-content .label { font-size: 0.85rem; font-weight: 600; text-transform: uppercase; opacity: 0.9; letter-spacing: 1px; margin-bottom: 5px; }
    .text-content .value { font-size: 2rem; font-weight: 800; text-shadow: 0 2px 4px rgba(0,0,0,0.2); }
    
    .icon-box { font-size: 3rem; opacity: 0.3; transform: rotate(-15deg); position: absolute; right: 15px; bottom: 10px; }
    
    /* Chart Card */
    .chart-card { border-radius: 15px; border: none; box-shadow: 0 0 15px rgba(0,0,0,0.05); margin-bottom: 30px; }
    .chart-card .card-header { 
        background: #fff; border-bottom: 1px solid #f0f0f0; 
        border-radius: 15px 15px 0 0; padding: 15px 20px; 
        font-weight: 700; color: #4e73df; font-size: 1.1rem;
    }
    .chart-container { position: relative; height: 350px; width: 100%; padding: 10px; }
</style>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800 fw-bold"><i class="fas fa-tachometer-alt me-2"></i>Tổng quan cửa hàng</h1>
        <div class="text-muted small"><i class="fas fa-calendar-alt me-1"></i> Hôm nay: <?= date('d/m/Y') ?></div>
    </div>

    <!-- HÀNG 1: HIỆU QUẢ KINH DOANH -->
    <div class="row g-4 mb-4">
        <!-- 1. DOANH THU -->
        <div class="col-xl-3 col-md-6">
            <div class="summary-card bg-gradient-primary">
                <div class="card-body-content">
                    <div class="text-content">
                        <div class="label">Doanh thu hôm nay</div>
                        <div class="value" id="today_revenue">0 ₫</div>
                    </div>
                    <div class="icon-box"><i class="fas fa-dollar-sign"></i></div>
                </div>
            </div>
        </div>
        
        <!-- 2. LỢI NHUẬN -->
        <div class="col-xl-3 col-md-6">
            <div class="summary-card bg-gradient-success">
                <div class="card-body-content">
                    <div class="text-content">
                        <div class="label">Lợi nhuận hôm nay</div>
                        <div class="value" id="today_profit">0 ₫</div>
                    </div>
                    <div class="icon-box"><i class="fas fa-chart-line"></i></div>
                </div>
            </div>
        </div>

        <!-- 3. ĐƠN HÀNG -->
        <div class="col-xl-3 col-md-6">
            <div class="summary-card bg-gradient-info">
                <div class="card-body-content">
                    <div class="text-content">
                        <div class="label">Đơn hàng hôm nay</div>
                        <div class="value" id="today_orders">0</div>
                    </div>
                    <div class="icon-box"><i class="fas fa-file-invoice"></i></div>
                </div>
            </div>
        </div>

        <!-- 4. TỔNG TỒN KHO -->
        <div class="col-xl-3 col-md-6">
            <div class="summary-card bg-gradient-warning">
                <div class="card-body-content">
                    <div class="text-content">
                        <div class="label">Tổng tồn kho</div>
                        <div class="value text-white" id="total_inventory">0</div>
                    </div>
                    <div class="icon-box"><i class="fas fa-boxes"></i></div>
                </div>
            </div>
        </div>
    </div>

    <!-- HÀNG 2: THỐNG KÊ CHI PHÍ (MỚI THÊM) -->
    <div class="row g-4 mb-4">
        <!-- 5. CHI PHÍ HÔM NAY -->
        <div class="col-xl-6 col-md-6">
            <div class="summary-card bg-gradient-danger">
                <div class="card-body-content">
                    <div class="text-content">
                        <div class="label">Chi phí Hôm nay</div>
                        <div class="value" id="today_expense">0 ₫</div>
                    </div>
                    <div class="icon-box"><i class="fas fa-money-bill-wave-alt"></i></div>
                </div>
            </div>
        </div>

        <!-- 6. CHI PHÍ THÁNG NÀY -->
        <div class="col-xl-6 col-md-6">
            <div class="summary-card bg-gradient-purple">
                <div class="card-body-content">
                    <div class="text-content">
                        <div class="label">Chi phí Tháng này</div>
                        <div class="value" id="month_expense">0 ₫</div>
                    </div>
                    <div class="icon-box"><i class="fas fa-calendar-minus"></i></div>
                </div>
            </div>
        </div>
    </div>

    <!-- HÀNG 3: BIỂU ĐỒ -->
    <div class="row">
        <!-- Biểu đồ Doanh số -->
        <div class="col-xl-8 col-lg-7">
            <div class="card chart-card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span><i class="fas fa-chart-bar me-2"></i>Biểu đồ doanh thu 7 ngày qua</span>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="salesChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Biểu đồ Top Sản phẩm -->
        <div class="col-xl-4 col-lg-5">
            <div class="card chart-card">
                <div class="card-header">
                    <span><i class="fas fa-medal me-2"></i>Top 10 Món bán chạy</span>
                </div>
                <div class="card-body">
                    <div class="chart-container" style="height: 320px;">
                        <canvas id="topProductsChart"></canvas>
                    </div>
                    <div class="mt-3 text-center small text-muted">
                        * Dữ liệu tính trong tháng này
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>

<!-- SCRIPT -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
$(document).ready(function() {
    const formatCurrency = (num) => new Intl.NumberFormat('vi-VN', { style: 'currency', currency: 'VND' }).format(num || 0);
    const formatNumber = (num) => new Intl.NumberFormat('vi-VN').format(num || 0);
    
    // Load Data
    $.ajax({
        url: '/quanlybanhang/ajax/dashboard_ajax.php',
        type: 'GET', data: { action: 'get_dashboard_data' },
        dataType: 'json',
        success: function(res) {
            if (res.status === 'success') {
                const d = res.data;
                
                // 1. Điền số liệu
                $('#today_revenue').text(formatCurrency(d.today_revenue));
                $('#today_profit').text(formatCurrency(d.today_profit));
                $('#today_orders').text(formatNumber(d.today_orders));
                $('#total_inventory').text(formatNumber(d.total_inventory));
                
                // Số liệu MỚI (Chi phí)
                $('#today_expense').text(formatCurrency(d.today_expense));
                $('#month_expense').text(formatCurrency(d.month_expense));
                
                // 2. Vẽ biểu đồ
                renderSalesChart(d.charts.sales_by_day);
                renderTopProductsChart(d.charts.top_products);
            }
        }
    });

    // --- CHART 1: DOANH SỐ ---
    function renderSalesChart(data) {
        const ctx = document.getElementById('salesChart').getContext('2d');
        let gradient = ctx.createLinearGradient(0, 0, 0, 400);
        gradient.addColorStop(0, 'rgba(78, 115, 223, 0.5)');
        gradient.addColorStop(1, 'rgba(78, 115, 223, 0.0)');

        new Chart(ctx, {
            type: 'line', 
            data: {
                labels: data.map(i => i.sale_day),
                datasets: [{
                    label: 'Doanh thu (VNĐ)',
                    data: data.map(i => i.daily_total),
                    borderColor: '#4e73df', backgroundColor: gradient,
                    pointBackgroundColor: '#4e73df', pointBorderColor: '#fff',
                    fill: true, tension: 0.4
                }]
            },
            options: {
                responsive: true, maintainAspectRatio: false,
                scales: { y: { beginAtZero: true, ticks: { callback: function(value) { return value.toLocaleString('vi-VN') + ' ₫'; } } } },
                plugins: { tooltip: { callbacks: { label: (ctx) => formatCurrency(ctx.raw) } }, legend: { display: false } }
            }
        });
    }

    // --- CHART 2: TOP SẢN PHẨM ---
    function renderTopProductsChart(data) {
        const ctx = document.getElementById('topProductsChart').getContext('2d');
        const labels = Object.values(data).map(d => d.name);
        const values = Object.values(data).map(d => d.total);
        const colors = ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b', '#858796', '#5a5c69', '#6f42c1', '#fd7e14', '#20c997'];

        new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: labels,
                datasets: [{ data: values, backgroundColor: colors, hoverBorderColor: "rgba(234, 236, 244, 1)" }],
            },
            options: {
                maintainAspectRatio: false, cutout: '70%',
                plugins: {
                    legend: { display: true, position: 'bottom', labels: { boxWidth: 10, padding: 10, font: { size: 11 } } },
                    tooltip: { callbacks: { label: (ctx) => ctx.label + ': ' + formatNumber(ctx.raw) + ' món' } }
                }
            }
        });
    }
});
</script>