<?php
require_once __DIR__ . '/../../templates/header.php';

// 1. Lấy ID phiếu nhập từ URL
if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("ID phiếu nhập không hợp lệ.");
}
$slip_id = intval($_GET['id']);

// 2. Lấy thông tin chính của phiếu nhập
$sql_slip = "SELECT i.*, s.supplier_name, st.store_name, u.display_name as user_name
             FROM cms_input i
             LEFT JOIN cms_suppliers s ON i.supplier_id = s.id
             LEFT JOIN cms_stores st ON i.store_id = st.id
             LEFT JOIN cms_users u ON i.user_init = u.id
             WHERE i.id = ? AND i.deleted = 0";
$stmt = $conn->prepare($sql_slip);
$stmt->bind_param("i", $slip_id);
$stmt->execute();
$slip_data = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$slip_data) {
    die("Không tìm thấy phiếu nhập hoặc phiếu đã bị xóa.");
}

// 3. Xử lý chi tiết sản phẩm
$products_in_slip = json_decode($slip_data['detail_input'], true);
// Lấy danh sách ID sản phẩm để truy vấn thông tin còn thiếu (như ĐVT)
$product_ids = array_column($products_in_slip, 'id');
$products_info = [];

if (!empty($product_ids)) {
    $ids_placeholder = implode(',', array_fill(0, count($product_ids), '?'));
    $types = str_repeat('i', count($product_ids));
    
    // Truy vấn để lấy tên ĐVT từ bảng `cms_products_unit`
    $sql_products = "SELECT p.id, u.prd_unit_name 
                     FROM cms_products p
                     LEFT JOIN cms_products_unit u ON p.prd_unit_id = u.id
                     WHERE p.id IN ($ids_placeholder)";
                     
    $stmt_products = $conn->prepare($sql_products);
    $stmt_products->bind_param($types, ...$product_ids);
    $stmt_products->execute();
    $products_result = $stmt_products->get_result();
    while ($row = $products_result->fetch_assoc()) {
        $products_info[$row['id']] = $row;
    }
    $stmt_products->close();
}
?>

<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Chi tiết Phiếu nhập <span class="text-primary"><?php echo htmlspecialchars($slip_data['input_code']); ?></span></h1>
        <div>
            <a href="danhsach_phieunhap.php" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left fa-sm"></i> Quay lại</a>
            <a href="print_slip.php?id=<?php echo $slip_id; ?>" target="_blank" class="btn btn-info btn-sm"><i class="fas fa-print fa-sm"></i> In phiếu</a>
            <a href="#" class="btn btn-danger btn-sm btn-delete-slip" data-id="<?php echo $slip_id; ?>"><i class="fas fa-trash fa-sm"></i> Hủy phiếu</a>
        </div>
    </div>
    
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-primary">Chi tiết sản phẩm</h6></div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" width="100%" cellspacing="0">
                            <thead>
                                <tr><th>STT</th><th>Mã SP</th><th>Tên sản phẩm</th><th>ĐVT</th><th class="text-right">Số lượng</th><th class="text-right">Giá nhập</th><th class="text-right">% CK</th><th class="text-right">Thành tiền</th></tr>
                            </thead>
                            <tbody>
                                <?php foreach ($products_in_slip as $index => $p): 
                                    $price = floatval($p['price'] ?? 0);
                                    $quantity = floatval($p['quantity'] ?? 0);
                                    $discount = floatval($p['discount_percent'] ?? 0);
                                    $line_total = ($price * $quantity) * (1 - $discount / 100);
                                ?>
                                <tr>
                                    <td><?php echo $index + 1; ?></td>
                                    <td><?php echo htmlspecialchars($p['code'] ?? 'N/A'); ?></td>
                                    <td><?php echo htmlspecialchars($p['name']); ?></td>
                                    <td><?php echo htmlspecialchars($products_info[$p['id']]['prd_unit_name'] ?? 'N/A'); ?></td>
                                    <td class="text-right"><?php echo number_format($quantity); ?></td>
                                    <td class="text-right"><?php echo number_format($price); ?></td>
                                    <td class="text-right"><?php echo $discount; ?>%</td>
                                    <td class="text-right"><?php echo number_format($line_total); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-primary">Thông tin chung</h6></div>
                <div class="card-body">
                    <p><strong>Nhà cung cấp:</strong> <?php echo htmlspecialchars($slip_data['supplier_name']); ?></p>
                    <p><strong>Kho nhập:</strong> <?php echo htmlspecialchars($slip_data['store_name'] ?? 'Chưa xác định'); ?></p>
                    <p><strong>Ngày nhập:</strong> <?php echo date('d/m/Y H:i', strtotime($slip_data['input_date'])); ?></p>
                    <p><strong>Người nhập:</strong> <?php echo htmlspecialchars($slip_data['user_name']); ?></p>
                    <p><strong>Ghi chú:</strong> <?php echo nl2br(htmlspecialchars($slip_data['notes'] ?: '(không có)')); ?></p>
                    <hr>
                    <p><strong>Tổng tiền hàng:</strong> <span class="float-right"><?php echo number_format($slip_data['total_price']); ?></span></p>
                    <p><strong>Chiết khấu (phiếu):</strong> <span class="float-right text-danger">-<?php echo number_format($slip_data['discount']); ?></span></p>
                    <h5 class="font-weight-bold">Tổng cộng: <span class="float-right text-primary"><?php echo number_format($slip_data['total_money']); ?></span></h5>
                    <p><strong>Đã thanh toán:</strong> <span class="float-right"><?php echo number_format($slip_data['payed']); ?></span></p>
                    <p><strong>Còn nợ:</strong> <span class="float-right font-weight-bold text-danger"><?php echo number_format($slip_data['lack']); ?></span></p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>

<script>
// Code JavaScript để xử lý nút Hủy phiếu
$(document).on('click', '.btn-delete-slip', function(e) {
    e.preventDefault();
    var slipId = $(this).data('id');
    if (confirm('Bạn có chắc chắn muốn hủy phiếu nhập này không? Thao tác này không thể hoàn tác.')) {
        $.ajax({
            url: '/quanlybanhang/ajax/imports_ajax.php',
            type: 'POST',
            dataType: 'json',
            data: { 
                action: 'delete_import_slip',
                slip_id: slipId 
            },
            success: function(response) {
                alert(response.message);
                if (response.status === 'success') {
                    // Chuyển về trang danh sách sau khi hủy thành công
                    window.location.href = 'danhsach_phieunhap.php';
                }
            },
            error: function() {
                alert('Có lỗi xảy ra, vui lòng thử lại.');
            }
        });
    }
});
</script>