<?php
require_once __DIR__ . '/../../core/init.php';
require_once __DIR__ . '/../../includes/payment_helpers.php';

$payment_id = intval($_GET['id'] ?? 0);
if ($payment_id <= 0) {
    die("ID phiếu chi không hợp lệ.");
}

$sql = "SELECT p.*, 
               creator.display_name as creator_name,
               CASE
                 WHEN p.type_id = 2 THEN payee_user.display_name
                 WHEN p.type_id IN (1, 3) THEN payee_supplier.supplier_name
                 ELSE ''
               END as payee_name,
               CASE
                 WHEN p.type_id IN (1, 3) THEN payee_supplier.supplier_addr
                 ELSE ''
               END as payee_address
        FROM cms_payment p
        LEFT JOIN cms_users creator ON p.user_init = creator.ID
        LEFT JOIN cms_suppliers payee_supplier ON p.payment_for = payee_supplier.ID AND p.type_id IN (1, 3)
        LEFT JOIN cms_users payee_user ON p.payment_for = payee_user.ID AND p.type_id = 2
        WHERE p.ID = ?";

$stmt = $conn->prepare($sql);
if ($stmt === false) {
    die("Lỗi chuẩn bị câu lệnh SQL: " . $conn->error);
}
$stmt->bind_param('i', $payment_id);
$stmt->execute();
$payment = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$payment) {
    die("Không tìm thấy phiếu chi.");
}

$payment_types = get_payment_types();
$payment_type_name = $payment_types[$payment['type_id']] ?? 'Không xác định';

// Hàm chuyển số thành chữ
function number_to_words_vietnamese($number) {
    // ... (Toàn bộ nội dung hàm chuyển số thành chữ như trong file in phiếu thu) ...
    $hyphen      = ' ';
    $conjunction = ' ';
    $separator   = ' ';
    $negative    = 'âm ';
    $decimal     = ' phẩy ';
    $dictionary  = array(0=>'không',1=>'một',2=>'hai',3=>'ba',4=>'bốn',5=>'năm',6=>'sáu',7=>'bảy',8=>'tám',9=>'chín',10=>'mười',11=>'mười một',12=>'mười hai',13=>'mười ba',14=>'mười bốn',15=>'mười lăm',16=>'mười sáu',17=>'mười bảy',18=>'mười tám',19=>'mười chín',20=>'hai mươi',30=>'ba mươi',40=>'bốn mươi',50=>'năm mươi',60=>'sáu mươi',70=>'bảy mươi',80=>'tám mươi',90=>'chín mươi',100=>'trăm',1000=>'nghìn',1000000=>'triệu',1000000000=>'tỷ',1000000000000=>'nghìn tỷ',1000000000000000=>'triệu tỷ',1000000000000000000=>'tỷ tỷ');
    if (!is_numeric($number)) return false;
    if ($number < 0) return $negative . number_to_words_vietnamese(abs($number));
    $string = $fraction = null;
    if (strpos($number, '.') !== false) list($number, $fraction) = explode('.', $number);
    switch (true) {
        case $number < 21: $string = $dictionary[$number]; break;
        case $number < 100:
            $tens   = ((int) ($number / 10)) * 10;
            $units  = $number % 10;
            $string = $dictionary[$tens];
            if ($units) $string .= $hyphen . ($units == 1 ? 'mốt' : ($units == 5 ? 'lăm' : $dictionary[$units]));
            break;
        case $number < 1000:
            $hundreds  = floor($number / 100);
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) $string .= $conjunction . ($remainder < 10 ? 'linh ' . number_to_words_vietnamese($remainder) : number_to_words_vietnamese($remainder));
            break;
        default:
            $baseUnit = pow(1000, floor(log($number, 1000)));
            $numBaseUnits = (int) ($number / $baseUnit);
            $remainder = $number % $baseUnit;
            $string = number_to_words_vietnamese($numBaseUnits) . ' ' . $dictionary[$baseUnit];
            if ($remainder) $string .= $remainder < 100 ? $conjunction . ' không trăm ' . ($remainder < 10 ? 'linh ' : '') . number_to_words_vietnamese($remainder) : $conjunction . number_to_words_vietnamese($remainder);
            break;
    }
    return ucfirst($string);
}
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <title>Phiếu chi - <?php echo htmlspecialchars($payment['payment_code']); ?></title>
    <style>
        body { font-family: 'Arial', sans-serif; font-size: 14px; margin: 0; padding: 0; background-color: #f4f4f4; }
        .page { width: 18cm; min-height: 10cm; padding: 1cm; margin: 1cm auto; border: 1px #D3D3D3 solid; border-radius: 5px; background: white; box-shadow: 0 0 5px rgba(0, 0, 0, 0.1); }
        .header { text-align: center; }
        h1 { font-size: 24px; color: #333; margin-top: 0; }
        .payment-info { margin-top: 20px; }
        .payment-info p { margin: 5px 0; line-height: 1.6; }
        .payment-info p strong { display: inline-block; min-width: 120px; }
        .amount-in-words { font-style: italic; }
        .footer { margin-top: 40px; display: flex; justify-content: space-around; text-align: center; }
        .footer div { width: 200px; }
        .footer .signature { margin-top: 50px; }
        @media print {
            body, .page { margin: 0; box-shadow: none; border: none; }
        }
    </style>
</head>
<body>
    <div class="page">
        <div class="header">
            <h1>PHIẾU CHI</h1>
            <p>Ngày <?php echo date('d', strtotime($payment['payment_date'])); ?> tháng <?php echo date('m', strtotime($payment['payment_date'])); ?> năm <?php echo date('Y', strtotime($payment['payment_date'])); ?></p>
            <p><strong>Số:</strong> <?php echo htmlspecialchars($payment['payment_code']); ?></p>
        </div>
        <div class="payment-info">
            <p><strong>Họ tên người nhận:</strong> <?php echo htmlspecialchars($payment['payee_name'] ?? 'N/A'); ?></p>
            <p><strong>Địa chỉ:</strong> <?php echo htmlspecialchars($payment['payee_address'] ?? ''); ?></p>
            <p><strong>Lý do chi:</strong> <?php echo htmlspecialchars($payment_type_name . ' - ' . $payment['notes']); ?></p>
            <p><strong>Số tiền:</strong> <?php echo number_format($payment['total_money'], 0, ',', '.'); ?> VNĐ</p>
            <p class="amount-in-words"><strong>(Viết bằng chữ):</strong> <?php echo htmlspecialchars(number_to_words_vietnamese($payment['total_money'])); ?> đồng.</p>
        </div>

        <div class="footer">
            <div>
                <strong>Người lập phiếu</strong><br>
                <em>(Ký, họ tên)</em>
                <div class="signature">
                    <?php echo htmlspecialchars($payment['creator_name']); ?>
                </div>
            </div>
            <div>
                <strong>Người nhận tiền</strong><br>
                <em>(Ký, họ tên)</em>
                <div class="signature"></div>
            </div>
             <div>
                <strong>Thủ trưởng</strong><br>
                <em>(Ký, họ tên)</em>
                <div class="signature"></div>
            </div>
        </div>
    </div>
    <script>
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>