<?php
require_once __DIR__ . '/../../core/init.php';

$slip_id = intval($_GET['id'] ?? 0);

if ($slip_id <= 0) {
    header('Location: list.php?error=' . urlencode('ID phiếu không hợp lệ.'));
    exit();
}

try {
    $stmt_delete = $conn->prepare("DELETE FROM cms_output WHERE ID = ?");
    $stmt_delete->bind_param("i", $slip_id);
    $stmt_delete->execute();
    
    if ($stmt_delete->affected_rows === 0) {
        throw new Exception("Không tìm thấy phiếu soạn hàng để xóa.");
    }
    $stmt_delete->close();
    
    header('Location: list.php?success=' . urlencode('Đã xóa phiếu soạn hàng thành công.'));

} catch (Exception $e) {
    header('Location: list.php?error=' . urlencode('Lỗi khi xóa phiếu: ' . $e->getMessage()));
}
exit();
?>