<?php
require_once __DIR__ . '/../../core/init.php';
require_once __DIR__ . '/../../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setTitle('Template Nhap San Pham');

// Thiết lập tiêu đề
$sheet->setCellValue('A1', 'Tên sản phẩm (*)');
$sheet->setCellValue('B1', 'Mã sản phẩm');
$sheet->setCellValue('C1', 'Ảnh (Vd: img/products/hinh1.jpg)'); // Cột mới
$sheet->setCellValue('D1', 'Giá vốn');
$sheet->setCellValue('E1', 'Giá bán lẻ (*)');
$sheet->setCellValue('F1', 'Giá bán sỉ');
$sheet->setCellValue('G1', 'Tên Danh mục');
$sheet->setCellValue('H1', 'Tên Nhà sản xuất');
$sheet->setCellValue('I1', 'Tên Đơn vị tính');
$sheet->setCellValue('J1', 'Size');
$sheet->setCellValue('K1', 'Màu sắc');

// In đậm tiêu đề
$sheet->getStyle('A1:K1')->getFont()->setBold(true);

// Tự động giãn cột
foreach (range('A', 'K') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="template_import_sanpham_v3.xlsx"');
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
?>