<?php
session_start();
require_once __DIR__ . '/../../core/init.php';
require_once __DIR__ . '/../../vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

$success_count = 0;
$error_count = 0;
$skipped_count = 0;
$errors = [];

if (isset($_FILES['import_file']) && $_FILES['import_file']['error'] == 0) {
    $fileName = $_FILES['import_file']['tmp_name'];
    try {
        $spreadsheet = IOFactory::load($fileName);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);
        
        $isFirstRow = true;
        foreach ($sheetData as $rowIndex => $row) {
            // Bỏ qua dòng tiêu đề
            if ($isFirstRow) { $isFirstRow = false; continue; }

            // --- 1. LẤY DỮ LIỆU TỪ EXCEL ---
            
            // Cột A: Tên sản phẩm (Bắt buộc)
            $prd_name = trim($row['A'] ?? '');
            if (empty($prd_name)) continue; 

            // Cột B: Mã sản phẩm
            $prd_code = trim($row['B'] ?? '');

            // Cột C: Ảnh sản phẩm (LOGIC QUAN TRỌNG)
            $raw_image = trim($row['C'] ?? '');
            $prd_image_url = '';
            
            if (!empty($raw_image)) {
                // Chuẩn hóa dấu gạch chéo (tránh lỗi nếu nhập nhầm)
                $raw_image = str_replace('\\', '/', $raw_image);
                
                // Nếu người dùng đã nhập full đường dẫn "img/products/..." thì giữ nguyên
                if (strpos($raw_image, 'img/products/') === 0) {
                    $prd_image_url = $raw_image;
                } else {
                    // Nếu chỉ nhập tên file (vd: anh1.jpg), tự động thêm tiền tố
                    $prd_image_url = 'img/products/' . $raw_image;
                }
            }

            // Cột D, E, F: Giá
            $prd_origin_price = (float)($row['D'] ?? 0);
            $prd_sell_price = (float)($row['E'] ?? 0);
            $prd_sell_price2 = (float)($row['F'] ?? 0);

            // Cột G, H, I: Tên danh mục, NSX, ĐVT
            $category_name = trim($row['G'] ?? '');
            $manufacturer_name = trim($row['H'] ?? '');
            $unit_name = trim($row['I'] ?? '');

            // Cột J, K: Size và Màu
            $prd_size = trim($row['J'] ?? '');
            $prd_color = trim($row['K'] ?? '');
            
            // --- 2. KIỂM TRA TRÙNG LẶP ---
            // Kiểm tra nếu Tên hoặc Mã đã tồn tại thì bỏ qua
            $check_sql = "SELECT id FROM cms_products WHERE prd_name = ? OR (prd_code != '' AND prd_code = ?)";
            $stmt_check = $conn->prepare($check_sql);
            $stmt_check->bind_param("ss", $prd_name, $prd_code);
            $stmt_check->execute();
            $result_check = $stmt_check->get_result();
            
            if ($result_check->num_rows > 0) {
                $skipped_count++;
                $stmt_check->close();
                continue; // Nhảy sang dòng tiếp theo
            }
            $stmt_check->close();

            // --- 3. TÌM ID TƯƠNG ỨNG (Lookup ID) ---
            
            // Tìm ID Danh mục
            $prd_group_id = 0;
            if(!empty($category_name)) {
                $stmt = $conn->prepare("SELECT id FROM cms_products_group WHERE prd_group_name = ?");
                $stmt->bind_param("s", $category_name); 
                $stmt->execute(); 
                $res = $stmt->get_result(); 
                if($res->num_rows > 0) $prd_group_id = $res->fetch_assoc()['id'];
                $stmt->close();
            }

            // Tìm ID Nhà sản xuất
            $prd_manufacture_id = 0;
            if(!empty($manufacturer_name)) {
                $stmt = $conn->prepare("SELECT id FROM cms_products_manufacture WHERE prd_manuf_name = ?");
                $stmt->bind_param("s", $manufacturer_name); 
                $stmt->execute();
                $res = $stmt->get_result(); 
                if($res->num_rows > 0) $prd_manufacture_id = $res->fetch_assoc()['id'];
                $stmt->close();
            }

            // Tìm ID Đơn vị tính
            $prd_unit_id = 0;
             if(!empty($unit_name)) {
                $stmt = $conn->prepare("SELECT id FROM cms_products_unit WHERE prd_unit_name = ?");
                $stmt->bind_param("s", $unit_name); 
                $stmt->execute();
                $res = $stmt->get_result(); 
                if($res->num_rows > 0) $prd_unit_id = $res->fetch_assoc()['id'];
                $stmt->close();
            }
            
            // --- 4. THÊM SẢN PHẨM MỚI ---
            // Câu lệnh INSERT đầy đủ các trường mới
            $sql = "INSERT INTO cms_products 
                    (prd_name, prd_code, prd_image_url, prd_origin_price, prd_sell_price, prd_sell_price2, 
                     prd_group_id, prd_manufacture_id, prd_unit_id, 
                     prd_size, prd_color, created, updated) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())";
            
            $stmt = $conn->prepare($sql);
            
            // Bind params: s (string), d (double/float), i (integer)
            // Thứ tự: Name(s), Code(s), Image(s), Origin(d), Sell(d), Sell2(d), Group(i), Manuf(i), Unit(i), Size(s), Color(s)
            // Tổng cộng: sssdddiiiss
            $stmt->bind_param("sssdddiiiss", 
                $prd_name, 
                $prd_code, 
                $prd_image_url, 
                $prd_origin_price, 
                $prd_sell_price, 
                $prd_sell_price2, 
                $prd_group_id, 
                $prd_manufacture_id, 
                $prd_unit_id, 
                $prd_size, 
                $prd_color
            );
            
            if($stmt->execute()) {
                $success_count++;
            } else {
                $error_count++;
                $errors[] = "Dòng $rowIndex: Lỗi SQL - " . $stmt->error;
            }
            $stmt->close();
        }

        // --- 5. TỔNG KẾT ---
        $message = "Import hoàn tất! <br>Thêm mới thành công: <strong>$success_count</strong>. <br>Bỏ qua (trùng lặp): <strong>$skipped_count</strong>. <br>Thất bại: <strong>$error_count</strong>.";
        
        if($error_count > 0) {
            $message .= "<br>Chi tiết lỗi: " . implode(", ", $errors);
        }
        
        $_SESSION['import_message'] = $message;

    } catch (Exception $e) {
        $_SESSION['import_message'] = 'Lỗi nghiêm trọng khi đọc file Excel: ' . $e->getMessage();
    }
} else {
     $_SESSION['import_message'] = 'Vui lòng chọn file Excel để upload.';
}

header('Location: /quanlybanhang/modules/products/list.php');
exit;
?>