<?php
require_once __DIR__ . '/../../templates/header.php';

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['product_images'])) {
        $target_dir = __DIR__ . '/../../img/products/';
        if (!file_exists($target_dir)) mkdir($target_dir, 0777, true);
        
        $count = count($_FILES['product_images']['name']);
        $success = 0;
        
        for ($i = 0; $i < $count; $i++) {
            $filename = $_FILES['product_images']['name'][$i];
            $tmp_name = $_FILES['product_images']['tmp_name'][$i];
            
            // Upload file, ghi đè nếu trùng tên để cập nhật ảnh dễ dàng
            if (move_uploaded_file($tmp_name, $target_dir . $filename)) {
                $success++;
            }
        }
        $message = "<div class='alert alert-success'>Đã tải lên thành công $success / $count ảnh.</div>";
    }
}
?>

<div class="container-fluid">
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Upload Ảnh Sản Phẩm Hàng Loạt</h6>
        </div>
        <div class="card-body">
            <?php echo $message; ?>
            
            <div class="alert alert-info">
                <strong>Hướng dẫn:</strong><br>
                1. Đặt tên file ảnh trùng với tên bạn đã nhập trong file Excel (Cột C).<br>
                2. Chọn tất cả ảnh (bôi đen) và nhấn Upload.<br>
                3. Hệ thống sẽ lưu ảnh vào thư mục <code>img/products/</code>.
            </div>

            <form action="" method="POST" enctype="multipart/form-data" class="text-center p-5 border border-dashed rounded" style="background: #f8f9fa; border: 2px dashed #ccc;">
                <i class="fas fa-cloud-upload-alt fa-3x text-gray-300 mb-3"></i>
                <div class="form-group">
                    <label for="file-upload" class="btn btn-primary btn-lg cursor-pointer">
                        <i class="fas fa-images"></i> Chọn nhiều ảnh cùng lúc
                    </label>
                    <input type="file" name="product_images[]" id="file-upload" multiple style="display:none" onchange="showCount(this)">
                </div>
                <p id="file-count" class="mt-2 font-weight-bold text-success"></p>
                <button type="submit" class="btn btn-success mt-3 px-5">BẮT ĐẦU UPLOAD</button>
            </form>
        </div>
    </div>
</div>

<script>
function showCount(input) {
    if (input.files && input.files.length > 0) {
        document.getElementById('file-count').innerHTML = 'Đã chọn ' + input.files.length + ' file ảnh.';
    }
}
</script>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>