<?php
require_once __DIR__ . '/../../core/init.php';

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: /quanlybanhang/modules/orders/list.php');
    exit();
}

$order_id = intval($_POST['order_id'] ?? 0);
$items_to_return_from_form = $_POST['items'] ?? [];
$user_id = $_SESSION['user_id'] ?? 0;

if (empty($order_id) || empty($items_to_return_from_form)) {
    $_SESSION['return_message'] = ['type' => 'danger', 'text' => 'Lỗi: Dữ liệu trả hàng không hợp lệ.'];
    header('Location: /quanlybanhang/modules/orders/list.php');
    exit();
}

$total_return_value = 0;
$has_items_to_return = false;

$conn->begin_transaction();
try {
    $stmt_insert_return = $conn->prepare("INSERT INTO cms_canreturn (order_id, product_id, quantity, price, user_init, created) VALUES (?, ?, ?, ?, ?, NOW())");
    $stmt_update_stock = $conn->prepare("UPDATE cms_products SET prd_sls = prd_sls + ? WHERE id = ?");

    foreach ($items_to_return_from_form as $item_from_form) {
        $return_quantity = intval($item_from_form['return_quantity'] ?? 0);
        if ($return_quantity > 0) {
            $has_items_to_return = true;
            $product_id = intval($item_from_form['id']);
            $price_at_sale = floatval($item_from_form['price']);

            // 1. Lưu vào bảng trả hàng (cms_canreturn)
            $stmt_insert_return->bind_param("iiidi", $order_id, $product_id, $return_quantity, $price_at_sale, $user_id);
            $stmt_insert_return->execute();

            // 2. Hoàn kho (cộng lại vào cms_products)
            $stmt_update_stock->bind_param("ii", $return_quantity, $product_id);
            $stmt_update_stock->execute();
            
            // 3. Tính tổng giá trị hàng trả lại
            $total_return_value += $return_quantity * $price_at_sale;
        }
    }
    
    $stmt_insert_return->close();
    $stmt_update_stock->close();

    if (!$has_items_to_return) {
        throw new Exception("Không có sản phẩm nào được chọn để trả.");
    }

    // 4. CẬP NHẬT TRỰC TIẾP CÔNG NỢ CỦA ĐƠN HÀNG GỐC
    // Logic này đảm bảo công nợ được giảm trừ chính xác
    if ($total_return_value > 0) {
        $stmt_update_order_debt = $conn->prepare("UPDATE cms_orders SET lack = lack - ? WHERE id = ?");
        $stmt_update_order_debt->bind_param("di", $total_return_value, $order_id);
        $stmt_update_order_debt->execute();
        $stmt_update_order_debt->close();
    }
    
    $conn->commit();
    $_SESSION['return_message'] = ['type' => 'success', 'text' => 'Ghi nhận trả hàng thành công! Công nợ của khách hàng đã được cập nhật.'];

} catch (Exception $e) {
    $conn->rollback();
    $_SESSION['return_message'] = ['type' => 'danger', 'text' => 'Lỗi khi xử lý trả hàng: ' . $e->getMessage()];
}

header('Location: /quanlybanhang/modules/orders/list.php');
exit();
?>