<?php
require_once __DIR__ . '/../../templates/header.php';

// =================================================================
// PHẦN 1: LẤY DỮ LIỆU BỘ LỌC VÀ CÁC THAM SỐ TỪ URL
// =================================================================

// Lấy dữ liệu cho các dropdown filter
$customers = $conn->query("SELECT ID, customer_name FROM cms_customers ORDER BY customer_name ASC")->fetch_all(MYSQLI_ASSOC);
$users = $conn->query("SELECT id, username FROM cms_users WHERE user_status = 1 ORDER BY username ASC")->fetch_all(MYSQLI_ASSOC);
$stores = $conn->query("SELECT id, store_name FROM cms_stores ORDER BY store_name ASC")->fetch_all(MYSQLI_ASSOC);

// Xử lý các tham số lọc từ URL
$group_by = $_GET['group_by'] ?? 'summary';
$from_date = $_GET['from'] ?? date('Y-m-01');
$to_date = $_GET['to'] ?? date('Y-m-t');
$customer_id = intval($_GET['customer_id'] ?? 0);
$user_id = intval($_GET['user_id'] ?? 0);
$store_id = intval($_GET['store_id'] ?? 0);

// =================================================================
// PHẦN 2: XÂY DỰNG MỆNH ĐỀ WHERE CHUNG CHO CÁC CÂU TRUY VẤN
// =================================================================

$whereClauses = ["o.deleted = 0", "o.order_status > 0"];
$params = [];
$types = '';

// Luôn có điều kiện ngày tháng
$from_datetime = $from_date . ' 00:00:00';
$to_datetime = $to_date . ' 23:59:59';
$whereClauses[] = "o.sell_date BETWEEN ? AND ?";
array_push($params, $from_datetime, $to_datetime);
$types .= 'ss';

// Thêm các điều kiện lọc nếu có
if ($customer_id > 0) { $whereClauses[] = "o.customer_id = ?"; $params[] = $customer_id; $types .= 'i'; }
if ($user_id > 0) { $whereClauses[] = "o.user_init = ?"; $params[] = $user_id; $types .= 'i'; }
if ($store_id > 0) { $whereClauses[] = "o.store_id = ?"; $params[] = $store_id; $types .= 'i'; }

// Nối các điều kiện lại thành một chuỗi
$whereSql = " WHERE " . implode(' AND ', $whereClauses);

// =================================================================
// PHẦN 3: TÍNH TOÁN CÁC SỐ LIỆU TỔNG HỢP CHO CÁC THẺ
// =================================================================

$sql_totals = "SELECT
                COUNT(o.id) as total_orders,
                SUM(o.total_quantity) as total_qty,
                SUM(o.discount_item) as total_discount,
                SUM(o.total_money) as total_revenue,
                SUM(o.lack) as total_debt
              FROM cms_orders o" . $whereSql;

$stmt_totals = $conn->prepare($sql_totals);
if ($stmt_totals) {
    if (!empty($types)) {
        $stmt_totals->bind_param($types, ...$params);
    }
    $stmt_totals->execute();
    $totals = $stmt_totals->get_result()->fetch_assoc();
    $stmt_totals->close();
} else {
    die("Lỗi prepare SQL totals: " . $conn->error);
}


// =================================================================
// PHẦN 4: LẤY DỮ LIỆU CHI TIẾT CHO BẢNG DỰA VÀO `group_by`
// =================================================================
$report_data = [];
$table_headers = [];

// Sử dụng switch-case để xử lý các loại báo cáo khác nhau
switch ($group_by) {
    case 'customer':
        $table_headers = ['Khách hàng', 'Số đơn', 'Tổng SL', 'Chiết khấu', 'Doanh số', 'Còn nợ'];
        $sql_report = "SELECT
                        c.customer_name,
                        COUNT(o.id) as order_count,
                        SUM(o.total_quantity) as sum_qty,
                        SUM(o.discount_item) as sum_discount,
                        SUM(o.total_money) as sum_revenue,
                        SUM(o.lack) as sum_debt
                     FROM cms_orders o
                     LEFT JOIN cms_customers c ON o.customer_id = c.ID
                     $whereSql
                     GROUP BY o.customer_id
                     ORDER BY sum_revenue DESC";
        break;

    case 'employee':
        $table_headers = ['Nhân viên', 'Số đơn', 'Tổng SL', 'Chiết khấu', 'Doanh số', 'Còn nợ'];
        $sql_report = "SELECT
                        u.username,
                        COUNT(o.id) as order_count,
                        SUM(o.total_quantity) as sum_qty,
                        SUM(o.discount_item) as sum_discount,
                        SUM(o.total_money) as sum_revenue,
                        SUM(o.lack) as sum_debt
                     FROM cms_orders o
                     LEFT JOIN cms_users u ON o.user_init = u.id
                     $whereSql
                     GROUP BY o.user_init
                     ORDER BY sum_revenue DESC";
        break;

    case 'product':
        $table_headers = ['Mã sản phẩm', 'Tên sản phẩm', 'Số lượng bán', 'Doanh số'];
        $sql_report = "SELECT
                        p.prd_code,
                        p.prd_name,
                        SUM(od.total_quantity) as sum_qty,
                        SUM(od.total_money) as sum_revenue
                     FROM cms_orders o
                     JOIN cms_output od ON o.ID = od.detail_order_id
                     JOIN cms_products p ON od.detail_product_id = p.ID
                     $whereSql
                     GROUP BY p.ID, p.prd_code, p.prd_name
                     ORDER BY sum_revenue DESC";
        break;

    case 'summary':
    default:
        $table_headers = ['Mã đơn hàng', 'Kho xuất', 'Ngày bán', 'Thu ngân', 'Khách hàng', 'SL', 'Chiết khấu', 'Tổng tiền', 'Nợ'];
        $sql_report = "SELECT
                        o.id, o.output_code, s.store_name as warehouse, o.sell_date, u.username as cashier,
                        c.customer_name, o.total_quantity, o.discount_item, o.total_money, o.lack
                     FROM cms_orders o
                     LEFT JOIN cms_stores s ON o.store_id = s.id
                     LEFT JOIN cms_users u ON o.user_init = u.id
                     LEFT JOIN cms_customers c ON o.customer_id = c.ID
                     $whereSql
                     ORDER BY o.id DESC";
        break;
}

$stmt_report = $conn->prepare($sql_report);
if ($stmt_report) {
    if (!empty($types)) {
        $stmt_report->bind_param($types, ...$params);
    }
    $stmt_report->execute();
    $report_data = $stmt_report->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt_report->close();
} else {
    // In ra lỗi để debug dễ hơn
    die("Lỗi prepare SQL report: " . $conn->error . "<br>Query: " . $sql_report);
}

$conn->close();
?>

<div class="container-fluid">
    <h1 class="h3 mb-2 text-gray-800">Báo cáo doanh thu</h1>
    <div class="card shadow mb-4">
        <div class="card-body">
            <form method="GET" id="filter-form">
                <div class="row mb-3">
                    <div class="col-md-12">
                        <input type="hidden" name="group_by" value="<?php echo htmlspecialchars($group_by); ?>">
                        <div class="btn-group btn-group-toggle" data-toggle="buttons">
                            <label class="btn btn-outline-primary <?php if($group_by == 'summary') echo 'active'; ?>"><input type="radio" name="group_by_option" value="summary" <?php if($group_by == 'summary') echo 'checked'; ?>> Báo cáo tổng hợp</label>
                            <label class="btn btn-outline-primary <?php if($group_by == 'customer') echo 'active'; ?>"><input type="radio" name="group_by_option" value="customer" <?php if($group_by == 'customer') echo 'checked'; ?>> Theo khách hàng</label>
                            <label class="btn btn-outline-primary <?php if($group_by == 'employee') echo 'active'; ?>"><input type="radio" name="group_by_option" value="employee" <?php if($group_by == 'employee') echo 'checked'; ?>> Theo NV bán hàng</label>
                            <label class="btn btn-outline-primary <?php if($group_by == 'product') echo 'active'; ?>"><input type="radio" name="group_by_option" value="product" <?php if($group_by == 'product') echo 'checked'; ?>> Theo hàng hóa</label>
                        </div>
                    </div>
                </div>
                <div class="row align-items-end">
                    <div class="col-md-2 mb-2"><select class="form-control" name="customer_id"><option value="">-- Khách hàng --</option><?php foreach($customers as $c) { echo "<option value='{$c['ID']}' ".($c['ID'] == $customer_id ? 'selected' : '').">".htmlspecialchars($c['customer_name'])."</option>"; } ?></select></div>
                    <div class="col-md-2 mb-2"><select class="form-control" name="user_id"><option value="">-- Thu ngân --</option><?php foreach($users as $u) { echo "<option value='{$u['id']}' ".($u['id'] == $user_id_from_get ? 'selected' : '').">".htmlspecialchars($u['username'])."</option>"; } ?></select></div>
                    <div class="col-md-2 mb-2"><select class="form-control" name="store_id"><option value="">-- Kho --</option><?php foreach($stores as $s) { echo "<option value='{$s['id']}' ".($s['id'] == $store_id ? 'selected' : '').">".htmlspecialchars($s['store_name'])."</option>"; } ?></select></div>
                    <div class="col-md-2 mb-2"><input type="date" class="form-control" name="from" value="<?php echo htmlspecialchars($from_date); ?>"></div>
                    <div class="col-md-2 mb-2"><input type="date" class="form-control" name="to" value="<?php echo htmlspecialchars($to_date); ?>"></div>
                    <div class="col-md-1 mb-2"><button type="submit" class="btn btn-primary btn-block">Tìm</button></div>
                    <div class="col-md-1 mb-2"><button type="button" class="btn btn-success btn-block" id="export-salary-btn">Báo cáo</button></div>
                </div>
            </form>
        </div>
    </div>
    </div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>

<script>
$(document).ready(function() {
    $('#dataTable').DataTable({"order": [], "language": { "url": "/quanlybanhang/assets/libs/datatables/vietnamese.json" }});

    // Sự kiện thay đổi loại báo cáo
    $('input[name="group_by_option"]').on('change', function() {
        $('input[name="group_by"]').val($(this).val());
        $(this).closest('form').submit();
    });

    // Sự kiện click nút "Báo cáo"
    $('#export-salary-btn').on('click', function(e) {
        e.preventDefault();
        var from = $('input[name="from"]').val();
        var to = $('input[name="to"]').val();
        var userId = $('select[name="user_id"]').val();

        // Kiểm tra đã chọn nhân viên chưa (chấp nhận user_id = 0)
        if (userId === '') {
            alert('Vui lòng chọn một nhân viên để xuất báo cáo.');
            return;
        }

        // Tạo URL tuyệt đối và chính xác đến file export
        var exportUrl = `/quanlybanhang/modules/revenue/export_salary_report.php?user_id=${userId}&from=${from}&to=${to}`;
        
        // Điều hướng để tải file
        window.location.href = exportUrl;
    });
});
</script>