<?php
// Đường dẫn: quanlybanhang/modules/settings/mayin.php

// --- BẬT HIỂN THỊ LỖI (DEBUG MODE) ---
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// --- INCLUDE FILES ---
// Lưu ý: Kiểm tra kỹ đường dẫn tương đối này
$path_helpers = __DIR__ . '/../../core/helpers.php';
$path_header  = __DIR__ . '/../../templates/header.php';
$path_footer  = __DIR__ . '/../../templates/footer.php';

if (file_exists($path_helpers)) require_once $path_helpers;
if (session_status() == PHP_SESSION_NONE) session_start();
if (file_exists($path_header)) require_once $path_header;

// --- KIỂM TRA KẾT NỐI DB ---
if (!isset($conn) || $conn->connect_error) {
    die("<div class='alert alert-danger m-3'>Lỗi: Mất kết nối CSDL. Kiểm tra file helpers.php</div>");
}

// --- LẤY DANH SÁCH MÁY IN ---
// Kiểm tra bảng tồn tại chưa để tránh crash
$check_table = $conn->query("SHOW TABLES LIKE 'pos_printers'");
if ($check_table->num_rows == 0) {
    die("<div class='alert alert-danger m-3'>Lỗi: Chưa có bảng dữ liệu. Vui lòng vào phpMyAdmin chạy lệnh tạo bảng 'pos_printers'.</div>");
}

$sql = "SELECT * FROM pos_printers ORDER BY id DESC";
$saved_printers = $conn->query($sql);
?>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Cấu hình Máy In (Mạng 192.168.107.x)</h1>
    
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">Danh sách thiết bị</h6>
                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#scanModal">
                        <i class="fas fa-search-plus me-1"></i> Quét tìm máy in mới
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead class="table-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Tên hiển thị</th>
                                    <th>Địa chỉ IP</th>
                                    <th>Thao tác</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($saved_printers && $saved_printers->num_rows > 0): ?>
                                    <?php while($row = $saved_printers->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= $row['id'] ?></td>
                                        <td><strong><?= htmlspecialchars($row['printer_name']) ?></strong></td>
                                        <td><span class="badge bg-info text-dark" style="font-size: 14px;"><?= $row['ip_address'] ?></span></td>
                                        <td>
                                            <button class="btn btn-sm btn-warning btn-test" data-ip="<?= $row['ip_address'] ?>">
                                                <i class="fas fa-print"></i> Test
                                            </button>
                                            <button class="btn btn-sm btn-danger btn-delete" data-id="<?= $row['id'] ?>">
                                                <i class="fas fa-trash"></i> Xóa
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr><td colspan="4" class="text-center text-muted">Chưa có máy in nào được cài đặt.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="scanModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Quét mạng 192.168.107.2 -> .254</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="text-center mb-3">
                    <button id="btnStartScan" class="btn btn-success w-100 py-2">
                        <i class="fas fa-radar"></i> BẮT ĐẦU QUÉT
                    </button>
                </div>
                
                <div id="scanLoading" class="text-center my-3" style="display:none;">
                    <div class="spinner-border text-primary" role="status"></div>
                    <p class="mt-2">Đang quét cổng 9100... Vui lòng chờ khoảng 20s...</p>
                </div>

                <div id="scanResults" class="list-group">
                    </div>
            </div>
        </div>
    </div>
</div>

<?php if (file_exists($path_footer)) include $path_footer; ?>

<script>
$(document).ready(function() {
    // 1. Nút Quét
    $('#btnStartScan').click(function() {
        $('#btnStartScan').hide();
        $('#scanLoading').show();
        $('#scanResults').html('');

        $.ajax({
            url: '/quanlybanhang/ajax/printer_ajax.php',
            type: 'POST',
            dataType: 'json',
            data: { action: 'scan_network' },
            success: function(res) {
                $('#scanLoading').hide();
                $('#btnStartScan').show().text('Quét lại');
                
                if (res.status === 'success' && res.data.length > 0) {
                    res.data.forEach(function(dev) {
                        $('#scanResults').append(`
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <span><i class="fas fa-print"></i> Found: <strong>${dev.ip}</strong></span>
                                <button class="btn btn-sm btn-primary btn-add" data-ip="${dev.ip}">Thêm</button>
                            </div>
                        `);
                    });
                } else {
                    $('#scanResults').html('<div class="alert alert-warning">Không tìm thấy máy in nào đang mở port 9100.</div>');
                }
            },
            error: function(xhr) {
                $('#scanLoading').hide();
                $('#btnStartScan').show();
                console.log(xhr.responseText); // Debug lỗi
                alert('Lỗi kết nối Server Ajax!');
            }
        });
    });

    // 2. Nút Thêm
    $(document).on('click', '.btn-add', function() {
        let ip = $(this).data('ip');
        let name = prompt("Đặt tên cho máy in này:", "May in " + ip);
        if(name) {
            $.post('/quanlybanhang/ajax/printer_ajax.php', {
                action: 'add_printer', ip: ip, name: name
            }, function(res) {
                if(res.status === 'success') {
                    alert('Đã thêm thành công!');
                    location.reload();
                } else {
                    alert(res.message);
                }
            }, 'json');
        }
    });

    // 3. Nút Xóa
    $('.btn-delete').click(function() {
        if(confirm('Bạn có chắc muốn xóa không?')) {
            $.post('/quanlybanhang/ajax/printer_ajax.php', {
                action: 'delete_printer', id: $(this).data('id')
            }, function(res) {
                location.reload();
            }, 'json');
        }
    });

    // 4. Nút Test Print
    $('.btn-test').click(function() {
        let btn = $(this);
        btn.prop('disabled', true).text('Đang in...');
        $.post('/quanlybanhang/ajax/printer_ajax.php', {
            action: 'test_print', ip: btn.data('ip')
        }, function(res) {
            alert(res.message);
            btn.prop('disabled', false).html('<i class="fas fa-print"></i> Test');
        }, 'json');
    });
});
</script>