<?php
require_once __DIR__ . '/../../templates/header.php';

// Code PHP lấy dữ liệu
$sql_users = "SELECT u.id, u.username AS ma_nhan_vien, u.display_name AS ten_nhan_vien, u.email, u.commission AS he_so_thuong, u.user_status, g.group_name FROM cms_users AS u LEFT JOIN cms_users_group AS g ON u.group_id = g.id ORDER BY u.id ASC";
$result_users = $conn->query($sql_users);
$staff_list = [];
if ($result_users && $result_users->num_rows > 0) {
    while($row = $result_users->fetch_assoc()) {
        $staff_list[] = $row;
    }
}

$sql_groups = "SELECT id, group_name FROM cms_users_group ORDER BY group_name ASC";
$result_groups = $conn->query($sql_groups);
$user_groups_list = [];
if ($result_groups && $result_groups->num_rows > 0) {
    while($row = $result_groups->fetch_assoc()) {
        $user_groups_list[] = $row;
    }
}

$stores_list = [1 => 'Kho 1', 2 => 'Kho 2', 3 => 'Kho trung tâm'];
?>

<div class="settings-panel">
    <ul class="nav nav-tabs">
        <li class="nav-item">
            <a class="nav-link active" href="/quanlybanhang/modules/users/list.php"><i class="fas fa-user mr-1"></i> Nhân viên</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="/quanlybanhang/modules/users/permissions.php"><i class="fas fa-cog mr-1"></i> Thiết lập chức năng</a>
        </li>
    </ul>

    <div class="tab-content pt-3">
        <div class="tab-pane fade show active">
            <div class="card shadow-none border">
                <div class="card-header bg-light">
                    <h6 class="m-0 font-weight-bold text-primary"><i class="fas fa-user-friends mr-2"></i>Danh sách nhân viên</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addUserModal">
                            <i class="fas fa-plus mr-1"></i> Tạo nhân viên
                        </button>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTableNhanVien" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Mã nhân viên</th>
                                    <th>Tên nhân viên</th>
                                    <th>Email</th>
                                    <th>Hệ số thưởng</th>
                                    <th>Nhóm người sử dụng</th>
                                    <th>Trạng thái</th>
                                    <th>Hành động</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tbody>
    <?php if (!empty($staff_list)): ?>

        <?php
            // Dòng gỡ lỗi: In ra toàn bộ dữ liệu của danh sách nhân viên
            echo '<pre>';
            var_dump($staff_list);
            echo '</pre>';

            // Dòng gỡ lỗi: Dừng chương trình lại để chỉ xem kết quả
            die("ĐÃ DUMP DỮ LIỆU XONG. BẠN HÃY COPY TOÀN BỘ NỘI DUNG TRÊN VÀ GỬI LẠI CHO TÔI.");
        ?>

        <?php
            // Code hiển thị cũ sẽ tạm thời không chạy do lệnh die() ở trên
            /*
            <?php foreach ($staff_list as $index => $staff): ?>
                <tr>
                    ...
                </tr>
            <?php endforeach; ?>
            */
        ?>

    <?php else: ?>
        <tr>
            <td colspan="8" class="text-center">Không tìm thấy nhân viên nào.</td>
        </tr>
    <?php endif; ?>
</tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="addUserModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-user-plus mr-2"></i>THÊM TÀI KHOẢN ĐĂNG NHẬP</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form id="addUserForm">
                    <div class="form-group row"><label class="col-sm-3 col-form-label">Tên nhân viên</label><div class="col-sm-9"><input type="text" class="form-control" name="display_name" required></div></div>
                    <div class="form-group row"><label class="col-sm-3 col-form-label">Mã nhân viên</label><div class="col-sm-9"><input type="text" class="form-control" name="username" required></div></div>
                    <div class="form-group row"><label class="col-sm-3 col-form-label">Email</label><div class="col-sm-9"><input type="email" class="form-control" name="email" required></div></div>
                    <div class="form-group row"><label class="col-sm-3 col-form-label">Hệ số thưởng</label><div class="col-sm-9"><input type="number" step="0.1" class="form-control" name="commission" value="0"></div></div>
                    <div class="form-group row"><label class="col-sm-3 col-form-label">Mật khẩu</label><div class="col-sm-9"><input type="password" class="form-control" name="password" required></div></div>
                    <div class="form-group row"><label class="col-sm-3 col-form-label">Nhóm người dùng</label><div class="col-sm-9"><select class="form-control" name="group_id" required><option value="">-- Chọn nhóm --</option><?php foreach ($user_groups_list as $group): ?><option value="<?php echo $group['id']; ?>"><?php echo htmlspecialchars($group['group_name']); ?></option><?php endforeach; ?></select></div></div>
                    <div class="form-group row"><label class="col-sm-3 col-form-label">Kho làm việc</label><div class="col-sm-9"><select class="form-control" name="store_id" required><?php foreach ($stores_list as $id => $name): ?><option value="<?php echo $id; ?>"><?php echo $name; ?></option><?php endforeach; ?></select></div></div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Bỏ qua</button>
                <button type="submit" class="btn btn-primary" form="addUserForm">Lưu</button>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>

<script>
$(document).ready(function() {
    $('#dataTableNhanVien').DataTable({
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.21/i18n/Vietnamese.json"
        }
    });

    $('#addUserForm').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize() + '&action=add_user';
        $.ajax({
            url: '/quanlybanhang/ajax/users_ajax.php',
            type: 'POST',
            dataType: 'json',
            data: formData,
            success: function(response) {
                alert(response.message);
                if (response.status === 'success') {
                    location.reload();
                }
            },
            error: function() {
                alert('Lỗi kết nối đến máy chủ.');
            }
        });
    });
});
</script>