<?php
// Giả định các file cần thiết đã được require ở đầu
if (file_exists(__DIR__ . '/../core/helpers.php')) {
    require_once __DIR__ . '/../core/helpers.php';
}

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

$current_page = basename($_SERVER['PHP_SELF']);
$current_module = basename(dirname($_SERVER['PHP_SELF']));

function is_active($module_name, $page_name = null) {
    global $current_module, $current_page;
    if ($page_name) {
        return ($current_module == $module_name && $current_page == $page_name) ? 'active' : '';
    }
    return ($current_module == $module_name) ? 'active' : '';
}
?>
<style>
    #sidebar-wrapper .sidebar-nav { background-color: #fff; }
    #sidebar-wrapper .sidebar-nav a { display: flex; align-items: center; padding: 14px 20px; font-size: 15px; color: #333; text-decoration: none; border-bottom: 1px solid #f0f0f0; transition: all 0.2s ease-in-out; }
    #sidebar-wrapper .sidebar-nav a i { margin-right: 15px; font-size: 16px; width: 20px; text-align: center; }
    #sidebar-wrapper .sidebar-nav a:hover,
    #sidebar-wrapper .sidebar-nav a.active { background-color: #F7941D; color: #fff; font-weight: bold; }
    #sidebar-wrapper .sidebar-nav a.logout-link { color: #d9534f; }
    #sidebar-wrapper .sidebar-nav a.logout-link:hover { background-color: #d9534f; color: #fff; }
</style>

<div class="bg-light border-right" id="sidebar-wrapper">
    <div class="sidebar-nav">
        
        <?php if (has_permission('pos')): ?>
        <a href="/quanlybanhang/modules/pos/pos.php" class="<?php echo is_active('pos', 'pos.php'); ?>"><i class="fas fa-cash-register fa-fw"></i><span>POS Bán hàng</span></a>
        <?php endif; ?>
        <?php if (has_permission('attendance')): ?>
<a href="/quanlybanhang/modules/attendance/index.php" class="<?php echo is_active('attendance'); ?>">
    <i class="fas fa-clock fa-fw"></i><span>Chấm công</span>
</a>
<?php endif; ?>
        
        <?php if (has_permission('dashboard')): ?>
        <a href="/quanlybanhang/modules/dashboard/index.php" class="<?php echo is_active('dashboard','index.php'); ?>"><i class="fas fa-tachometer-alt fa-fw"></i><span>Tổng quan</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('orders')): ?>
        <a href="/quanlybanhang/modules/orders/list.php" class="<?php echo is_active('orders'); ?>"><i class="fas fa-file-invoice-dollar fa-fw"></i><span>Đơn hàng</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('picking_slip')): ?>
        <a href="/quanlybanhang/modules/picking_slip/list.php" class="<?php echo is_active('picking_slip'); ?>"><i class="fas fa-clipboard-list fa-fw"></i><span>Phiếu soạn hàng</span></a>
        <?php endif; ?>
        <?php if (has_permission('tables')): ?>
<a href="/quanlybanhang/modules/tables/index.php" class="<?php echo is_active('tables'); ?>">
    <i class="fas fa-chair fa-fw"></i><span>Bàn & Khu vực</span>
</a>
<?php endif; ?>
        
        <?php if (has_permission('consolidate_orders')): ?>
        <a href="/quanlybanhang/modules/consolidate_orders/index.php" class="<?php echo is_active('consolidate_orders', 'index.php'); ?>"><i class="fas fa-layer-group fa-fw"></i><span>Gộp đơn hàng</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('products')): ?>
        <a href="/quanlybanhang/modules/products/list.php" class="<?php echo is_active('products'); ?>"><i class="fas fa-box-open fa-fw"></i><span>Sản phẩm</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('customers')): ?>
        <a href="/quanlybanhang/modules/customers/list.php" class="<?php echo is_active('customers'); ?>">
            <i class="fas fa-users fa-fw"></i><span>Khách hàng</span>
        </a>
        <?php endif; ?>
        
        <?php if (has_permission('suppliers')): ?>
        <a href="/quanlybanhang/modules/suppliers/list.php" class="<?php echo is_active('suppliers'); ?>">
            <i class="fas fa-truck fa-fw"></i><span>Nhà cung cấp</span>
        </a>
        <?php endif; ?>
        
        <?php if (has_permission('imports')): ?>
        <a href="/quanlybanhang/modules/imports/danhsach_phieunhap.php" class="<?php echo is_active('imports'); ?>"><i class="fas fa-dolly-flatbed fa-fw"></i><span>Nhập kho</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('transfer')): ?>
        <a href="/quanlybanhang/modules/transfers/list.php" class="<?php echo is_active('transfer'); ?>"><i class="fas fa-exchange-alt fa-fw"></i><span>Chuyển kho</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('inventory')): ?>
        <a href="/quanlybanhang/modules/inventory/index.php" class="<?php echo is_active('inventory'); ?>"><i class="fas fa-warehouse fa-fw"></i><span>Tồn kho</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('receipts')): ?>
        <a href="/quanlybanhang/modules/receipts/index.php" class="<?php echo is_active('receipts'); ?>"><i class="fas fa-arrow-down fa-fw"></i><span>Phiếu thu</span></a>
        <?php endif; ?>

        <?php if (has_permission('payments')): ?>
        <a href="/quanlybanhang/modules/payments/index.php" class="<?php echo is_active('payments'); ?>"><i class="fas fa-arrow-up fa-fw"></i><span>Phiếu Chi</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('reports')): // Doanh số ?>
        <a href="/quanlybanhang/modules/revenue/index.php" class="<?php echo is_active('revenue'); ?>"><i class="fas fa-chart-bar fa-fw"></i><span>Doanh số</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('cashbook')): ?>
        <a href="/quanlybanhang/modules/cashbook/index.php" class="<?php echo is_active('cashbook'); ?>"><i class="fas fa-book fa-fw"></i><span>Sổ quỹ</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('profit')): ?>
        <a href="/quanlybanhang/modules/profit/index.php" class="<?php echo is_active('profit'); ?>"><i class="fas fa-chart-line fa-fw"></i><span>Lợi nhuận</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('summary')): // Báo cáo tổng hợp ?>
        <a href="#"><i class="fas fa-chart-pie fa-fw"></i><span>Báo cáo tổng hợp</span></a>
        <?php endif; ?>
        
        <?php if (has_permission('settings')): // Thiết lập ?>
        <a href="/quanlybanhang/modules/users/permissions.php" class="<?php echo is_active('users', 'permissions.php'); ?>"><i class="fas fa-shield-alt fa-fw"></i><span>Thiết lập</span></a>
        <?php endif; ?>
        <?php if (has_permission('payroll')): ?>
<a href="/quanlybanhang/modules/payroll/index.php" class="<?php echo is_active('payroll'); ?>">
    <i class="fas fa-calculator fa-fw"></i><span>Tính lương</span>
</a>
<?php endif; ?>
        
        <a href="/quanlybanhang/logout.php" class="logout-link"><i class="fas fa-sign-out-alt fa-fw"></i><span>Đăng xuất</span></a>
        
    </div>
</div>