<?php
require_once __DIR__ . '/core/init.php';
echo "<h1>Bắt đầu quá trình nâng cấp dữ liệu đơn hàng...</h1>";
set_time_limit(300); // Tăng thời gian chạy script nếu có nhiều đơn hàng

// Lấy tất cả đơn hàng
$result = $conn->query("SELECT id, detail_order FROM cms_orders");
if (!$result) {
    die("Không thể truy vấn đơn hàng: " . $conn->error);
}

$orders_to_update = [];
$products_needed = [];
$item_map = [];

while ($order = $result->fetch_assoc()) {
    $order_id = $order['id'];
    $items = json_decode($order['detail_order'], true);
    $needs_update = false;

    if (!is_array($items)) {
        continue; // Bỏ qua nếu dữ liệu không phải JSON hợp lệ
    }

    // Kiểm tra xem đơn hàng này có cần cập nhật không
    foreach ($items as $item) {
        if (!isset($item['name']) || !isset($item['code'])) {
            $needs_update = true;
            if(isset($item['id'])) {
                $products_needed[] = $item['id'];
            }
        }
    }

    if ($needs_update) {
        $orders_to_update[$order_id] = $items;
    }
}

if (empty($orders_to_update)) {
    echo "<h2>Tất cả đơn hàng đã ở định dạng mới nhất. Không cần nâng cấp.</h2>";
    exit;
}

// Lấy thông tin của các sản phẩm cần cập nhật
$products_info = [];
$unique_product_ids = array_unique($products_needed);
if (!empty($unique_product_ids)) {
    $sql_products = "SELECT id, prd_code, prd_name FROM cms_products WHERE id IN (". implode(',', array_fill(0, count($unique_product_ids), '?')) .")";
    $stmt_products = $conn->prepare($sql_products);
    $stmt_products->bind_param(str_repeat('i', count($unique_product_ids)), ...$unique_product_ids);
    $stmt_products->execute();
    $products_result = $stmt_products->get_result();
    while ($row = $products_result->fetch_assoc()) {
        $products_info[$row['id']] = $row;
    }
    $stmt_products->close();
}

// Cập nhật lại các đơn hàng
$updated_count = 0;
$stmt_update = $conn->prepare("UPDATE cms_orders SET detail_order = ? WHERE id = ?");

foreach ($orders_to_update as $order_id => $items) {
    $new_items = [];
    foreach ($items as $item) {
        if (isset($item['id']) && isset($products_info[$item['id']])) {
            $product = $products_info[$item['id']];
            $item['name'] = $product['prd_name']; // Thêm name
            $item['code'] = $product['prd_code']; // Thêm code
        }
        $new_items[] = $item;
    }

    $new_detail_order_json = json_encode($new_items);
    $stmt_update->bind_param("si", $new_detail_order_json, $order_id);
    $stmt_update->execute();
    $updated_count++;
    echo "<p>Đã cập nhật đơn hàng ID: $order_id</p>";
}

$stmt_update->close();
echo "<h2>Nâng cấp hoàn tất! Đã cập nhật $updated_count đơn hàng.</h2>";
echo "<p style='color:red; font-weight:bold;'>Bây giờ bạn có thể xóa file upgrade_orders.php này đi.</p>";
?>