<?php
// SỬA LỖI: Xóa các dòng require_once header.php và init.php không cần thiết ở đây
require_once __DIR__ . '/../core/init.php'; 
header('Content-Type: application/json');

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

$action = $_REQUEST['action'] ?? '';

if ($action == 'get_permissions') {
    $group_id = intval($_GET['group_id'] ?? 0);
    $response = ['status' => 'error', 'permissions' => []];
    if ($group_id > 0) {
        $stmt = $conn->prepare("SELECT group_permission FROM cms_users_group WHERE id = ?");
        $stmt->bind_param("i", $group_id);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();
        $stmt->close();
        if ($result && !empty($result['group_permission'])) {
            $response['status'] = 'success';
            $response['permissions'] = json_decode($result['group_permission'], true);
        }
    }
    echo json_encode($response);
    exit;
}

if ($action == 'save_permissions') {
    $group_id = intval($_POST['group_id'] ?? 0);
    $permissions = $_POST['permissions'] ?? [];
    $permissions_json = json_encode($permissions);
    
    $response = ['status' => 'error', 'message' => 'Lưu quyền thất bại.'];
    if ($group_id > 0) {
        $stmt = $conn->prepare("UPDATE cms_users_group SET group_permission = ? WHERE id = ?");
        $stmt->bind_param("si", $permissions_json, $group_id);
        if ($stmt->execute()) {
            $response = ['status' => 'success', 'message' => 'Đã cập nhật quyền thành công!'];
        }
        $stmt->close();
    }
    echo json_encode($response);
    exit;
}
?>