<?php
require_once __DIR__ . '/../core/init.php';
header('Content-Type: application/json');
$response = ['status' => 'error', 'message' => 'Hành động không hợp lệ.'];

// === LẤY DANH SÁCH ===
if (isset($_GET['action'])) {
    $action = $_GET['action'];
    $data = [];
    $sql = '';

    if ($action == 'list_manufacturers') $sql = "SELECT id, prd_manuf_name FROM cms_products_manufacture ORDER BY id DESC";
    if ($action == 'list_categories') $sql = "SELECT id, prd_group_name FROM cms_products_group ORDER BY id DESC";
    if ($action == 'list_units') $sql = "SELECT id, prd_unit_name FROM cms_products_unit ORDER BY id DESC";

    if ($sql) {
        $result = $conn->query($sql);
        if ($result) while($row = $result->fetch_assoc()) { $data[] = $row; }
        $response = ['status' => 'success', 'data' => $data];
    }
}

// === THÊM MỚI ===
if (isset($_POST['action'])) {
    $name = isset($_POST['name']) ? trim($_POST['name']) : '';
    if (empty($name)) {
        $response['message'] = 'Tên không được để trống';
    } else {
        $action = $_POST['action'];
        $sql = '';
        $new_item_name = '';

        if ($action == 'add_manufacturer') {
            $sql = "INSERT INTO cms_products_manufacture (prd_manuf_name) VALUES (?)";
            $new_item_name = 'Thêm nhà sản xuất thành công!';
        }
        if ($action == 'add_category') {
            $sql = "INSERT INTO cms_products_group (prd_group_name) VALUES (?)";
             $new_item_name = 'Thêm danh mục thành công!';
        }
        if ($action == 'add_unit') {
            $sql = "INSERT INTO cms_products_unit (prd_unit_name) VALUES (?)";
             $new_item_name = 'Thêm đơn vị tính thành công!';
        }

        if ($sql) {
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("s", $name);
            if ($stmt->execute()) {
                $new_id = $conn->insert_id;
                $response = ['status' => 'success', 'message' => $new_item_name, 'new_item' => ['id' => $new_id, 'name' => $name]];
            } else {
                $response['message'] = 'Lỗi khi lưu vào CSDL: ' . $stmt->error;
            }
            $stmt->close();
        }
    }
}

echo json_encode($response);
$conn->close();
?>