<?php
require_once __DIR__ . '/../core/init.php';

header('Content-Type: application/json; charset=utf-8');
$action = $_POST['action'] ?? '';

if ($action == 'save_print_settings') {
    if (session_status() == PHP_SESSION_NONE) { session_start(); }
    $conn->begin_transaction();
    try {
        // Lấy cài đặt hiện tại từ CSDL để cập nhật
        $result = $conn->query("SELECT content FROM cms_templates WHERE id = 1");
        $current_settings = [];
        if($result && $result->num_rows > 0) {
            $current_settings = json_decode($result->fetch_assoc()['content'], true);
        }
        if (!is_array($current_settings)) $current_settings = [];

        // Lặp qua các dữ liệu text được gửi từ form và cập nhật vào mảng settings
        foreach ($_POST as $key => $value) {
            if ($key !== 'action' && $key !== 'current_image') {
                $current_settings[$key] = trim($value);
            }
        }
        
        $new_logo_path = null;
        // Xử lý upload file logo nếu có
        if (isset($_FILES['company_logo']) && $_FILES['company_logo']['error'] == 0) {
            $target_dir = __DIR__ . "/../uploads/logo/";
            if (!is_dir($target_dir)) { mkdir($target_dir, 0755, true); }
            
            // Xóa logo cũ nếu có để tránh rác
            $old_logo_path = $current_settings['company_logo'] ?? '';
            if(!empty($old_logo_path) && file_exists(__DIR__ . "/../../" . $old_logo_path)) {
                unlink(__DIR__ . "/../../" . $old_logo_path);
            }

            $file_extension = strtolower(pathinfo($_FILES["company_logo"]["name"], PATHINFO_EXTENSION));
            $file_name = "logo_" . time() . "." . $file_extension;
            $target_file = $target_dir . $file_name;

            if (move_uploaded_file($_FILES["company_logo"]["tmp_name"], $target_file)) {
                $new_logo_path = 'uploads/logo/' . $file_name;
                $current_settings['company_logo'] = $new_logo_path;
            }
        }

        // Mã hóa lại toàn bộ mảng settings thành JSON để lưu vào CSDL
        $new_content_json = json_encode($current_settings, JSON_UNESCAPED_UNICODE);
        $stmt = $conn->prepare("UPDATE cms_templates SET content = ? WHERE id = 1");
        $stmt->bind_param('s', $new_content_json);
        $stmt->execute();
        $stmt->close();
        
        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => 'Lưu cài đặt thành công!', 'new_logo_path' => $new_logo_path]);

    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode(['status' => 'error', 'message' => 'Lỗi khi lưu cài đặt: ' . $e->getMessage()]);
    }
    exit();
}

// Trả về lỗi nếu không có action nào khớp
echo json_encode(['status' => 'error', 'message' => 'Hành động không hợp lệ.']);
?>