<?php
function sendSmsViaMobileApi($endpoint, $token, $to, $message) {
    $url = $endpoint;
    $data = [
        'to' => $to,
        'message' => $message,
        'token' => $token
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length: ' . strlen(json_encode($data))
    ]);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    
    curl_close($ch);

    // Ghi log chi tiết
    error_log("cURL Request: URL=$url, Data=" . json_encode($data));
    error_log("cURL Response: HTTP $http_code | Error: $error | Response: " . ($response ?: 'No response'));

    if ($http_code != 200) {
        return false;
    }

    $result = json_decode($response, true);
    return isset($result['status']) && $result['status'] === 'success';
}
?>