<?php
session_start();
// Nạp file helpers để có hàm is_mobile()
require_once __DIR__ . '/core/helpers.php'; 

// (MỚI) Xử lý người dùng đã đăng nhập
if (isset($_SESSION['user_id'])) {
    
    if (is_mobile()) {
        // 1. Nếu là điện thoại -> Chuyển đến app mobile MỚI
        header('Location: mobile.php');
    } else {
        // 2. Nếu là desktop -> Giữ nguyên logic cũ (hoặc logic tương tự process_login.php)
        if ((int)$_SESSION['group_id'] === 7) { 
            header('Location: modules/pos/pos-mobile.php'); 
        } else {
            header('Location: modules/dashboard/');
        }
    }
    exit();
}

$error_message = '';
if (isset($_GET['error'])) {
    switch ($_GET['error']) {
        case '1':
            $error_message = 'Tài khoản hoặc mật khẩu không chính xác!';
            break;
        case '2':
            $error_message = 'Tài khoản của bạn đã bị khóa!';
            break;
        default:
            $error_message = 'Có lỗi xảy ra. Vui lòng thử lại.';
            break;
    }
}
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Đăng nhập hệ thống</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        body { background-color: #f0f2f5; }
        .login-container { max-width: 400px; margin: 8% auto; padding: 2rem; background-color: #fff; border-radius: 0.5rem; box-shadow: 0 0.5rem 1rem rgba(0,0,0,.15); }
    </style>
</head>
<body>
    <div class="login-container">
        <h2 class="text-center mb-4">Đăng nhập</h2>
        <?php if (!empty($error_message)): ?>
            <div class="alert alert-danger"><?php echo $error_message; ?></div>
        <?php endif; ?>
        
        <form action="process_login.php" method="POST">
            <div class="form-floating mb-3">
                <input type="text" class="form-control" id="username" name="username" placeholder="Tên đăng nhập" required>
                <label for="username">Tên đăng nhập (Mã nhân viên)</label>
            </div>
            <div class="form-floating mb-3">
                <input type="password" class="form-control" id="password" name="password" placeholder="Mật khẩu" required>
                <label for="password">Mật khẩu</label>
            </div>
            <div class="d-grid">
                <button class="btn btn-primary btn-lg" type="submit">Đăng nhập</button>
            </div>
        </form>
    </div>
</body>
</html>