<?php
// FILE NÀY: banhang/mobile_views/products.php
$is_selection_mode = isset($_GET['select']) && $_GET['select'] === 'true';

/*
----------------------------------------------------------------------
--- PHẦN 1: LẤY DỮ LIỆU THẬT ---
----------------------------------------------------------------------
(MỚI) Tải TẤT CẢ sản phẩm ĐANG KINH DOANH bằng PHP
*/

$products_data = [];
$sql = "SELECT p.ID as id, p.prd_name, p.prd_code, p.prd_image_url, p.prd_status, 
               p.prd_sls AS prd_inventory, p.prd_sell_price, p.prd_sell_price2, p.prd_origin_price,
               p.prd_unit_id, u.prd_unit_name
        FROM cms_products p
        LEFT JOIN cms_products_unit u ON p.prd_unit_id = u.id
        WHERE p.deleted = 0 AND p.prd_status = 1 
        ORDER BY p.prd_name ASC";
        
$stmt = $conn->prepare($sql);
$stmt->execute();
$products_data = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

?>

<div class="pos-search-bar" style="top: 0; padding: 16px; margin: 0 -16px; background-color: var(--card-bg); border-bottom: 1px solid var(--border-color);">
    <div class="search-box">
        <i class="fa-solid fa-search"></i>
        <input type="text" id="product-search-input" placeholder="Tìm tên, mã sản phẩm..." autocomplete="off" autofocus>
    </div>
</div>

<div class="list-container" id="product-list-container" style="padding-top: 16px;">
    <?php if (empty($products_data)): ?>
        <p class="no-items" style="padding: 20px; text-align: center; color: var(--text-light);">Không có sản phẩm nào đang kinh doanh.</p>
    <?php endif; ?>

    <?php foreach ($products_data as $p): ?>
        <?php
            // Chuyển đổi dữ liệu để truyền cho JavaScript
            $product_json_data = htmlspecialchars(json_encode([
                'id' => $p['id'],
                'code' => $p['prd_code'],
                'name' => $p['prd_name'],
                'inventory' => $p['prd_inventory'],
                'origin_price' => $p['prd_origin_price'],
                'price_retail' => $p['prd_sell_price'],
                'price_wholesale' => $p['prd_sell_price2'],
                'unit' => $p['prd_unit_name'] ?? 'N/A',
                'quantity' => 1,
                'percent' => 0
            ]), ENT_QUOTES, 'UTF-8');
            
            // Dữ liệu cho JS live search (bỏ dấu)
            $search_data = strtolower($p['prd_name'] . $p['prd_code']);
        ?>
    
        <div class="list-card product-card btn-select-product" data-id="<?php echo $p['id']; ?>" data-search="<?php echo htmlspecialchars($search_data); ?>" data-product-json='<?php echo $product_json_data; ?>'>
            <div class="list-card-header">
                <div class="list-card-title">
                    <span class="product-name-highlight"><?php echo htmlspecialchars($p['prd_name']); ?></span>
                    <span class="sub-text">Mã: <?php echo htmlspecialchars($p['prd_code']); ?></span>
                </div>
                
                <?php
                    $inventory = (int)$p['prd_inventory'];
                    $stock_class = 'stock-good'; // Xanh lá
                    if ($inventory <= 0) $stock_class = 'stock-out'; // Đỏ
                    else if ($inventory < 5) $stock_class = 'stock-low'; // Vàng
                ?>
                <div class="product-inventory <?php echo $stock_class; ?>">
                    Tồn: <?php echo $inventory; ?>
                </div>
            </div>
            
            <div class="list-card-body product-price-grid">
                <div class="price-item">
                    <span class="label">Giá vốn</span>
                    <span class="value cost-price"><?php echo number_format($p['prd_origin_price'], 0, ',', '.'); ?> đ</span>
                </div>
                <div class="price-item">
                    <span class="label">Giá lẻ</span>
                    <span class="value sell-price"><?php echo number_format($p['prd_sell_price'], 0, ',', '.'); ?> đ</span>
                </div>
                <div class="price-item">
                    <span class="label">Giá sỉ</span>
                    <span class="value wholesale-price"><?php echo number_format($p['prd_sell_price2'], 0, ',', '.'); ?> đ</span>
                </div>
            </div>
            
            <div class="selection-checkmark">
                <i class="fa-solid fa-check-circle"></i>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<footer class="pos-footer-actions">
    <a href="pos_mobile.php" class="btn-action-footer btn-draft" style="flex: 1;">
        <i class="fa-solid fa-arrow-left"></i>
        <span>Quay lại Giỏ hàng (<span id="selected-items-count">0</span>)</span>
    </a>
</footer>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('product-search-input');
    const listContainer = document.getElementById('product-list-container');
    const allCards = listContainer.querySelectorAll('.btn-select-product');
    const countEl = document.getElementById('selected-items-count');
    
    let cart = JSON.parse(localStorage.getItem('pos_cart') || '[]');
    const customer = JSON.parse(localStorage.getItem('pos_customer') || '{"group":1}');

    // --- 1. Hàm đánh dấu sản phẩm đã chọn ---
    function updateSelectedMarkers() {
        allCards.forEach(card => {
            const id = card.dataset.id;
            const itemInCart = cart.find(item => item.id == id);
            if (itemInCart) {
                card.classList.add('is-in-cart');
            } else {
                card.classList.remove('is-in-cart');
            }
        });
        countEl.textContent = cart.length;
    }

    // --- 2. Gán sự kiện Click để Thêm/Cập nhật ---
    allCards.forEach(button => {
        button.addEventListener('click', function() {
            const productData = JSON.parse(this.dataset.productJson);
            
            // Gán giá bán chính xác khi chọn
            let priceToUse = productData.price_retail;
            if (customer.group == 0 && parseFloat(productData.price_wholesale) > 0) {
                priceToUse = productData.price_wholesale;
            }
            productData.price = priceToUse;

            // Kiểm tra xem SP đã có trong giỏ chưa
            let itemInCart = cart.find(item => item.id == productData.id);
            if (itemInCart) {
                itemInCart.quantity++; // Tăng số lượng
            } else {
                cart.push(productData); // Thêm mới
            }
            
            localStorage.setItem('pos_cart', JSON.stringify(cart));
            
            // Quay lại trang POS
            window.location.href = 'pos_mobile.php';
        });
    });

    // --- 3. Hàm tìm kiếm "Live" (Lọc JS) ---
    function normalizeText(text) {
        return text.toLowerCase().normalize("NFD").replace(/[\u0300-\u036f]/g, "");
    }
    
    searchInput.addEventListener('keyup', function() {
        const searchTerm = normalizeText(this.value);
        
        allCards.forEach(card => {
            const searchData = card.dataset.search; // Đã là lowercase và bỏ dấu
            if (searchData.includes(searchTerm)) {
                card.style.display = 'block';
            } else {
                card.style.display = 'none';
            }
        });
    });

    // --- 4. Khởi tạo ---
    updateSelectedMarkers();
    searchInput.focus();
});
</script>