<?php
require_once __DIR__ . '/../../templates/header.php';

$users_result = $conn->query("SELECT id, username, display_name FROM cms_users WHERE user_status = 1 ORDER BY display_name ASC");
$users = $users_result->fetch_all(MYSQLI_ASSOC);
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
<style>
    #orders-list-table thead th { 
        background-color:#4e73df !important; 
        color:#ffffff !important; 
        font-weight:bold; 
        vertical-align: middle; 
    }
    .processed-row {
        background-color: #f8f9fc !important;
        color: #858796;
        text-decoration: line-through;
        opacity: 0.8;
    }
</style>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Gộp và Cập nhật Ngày Đơn Hàng</h1>
    
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Bước 1: Lọc đơn hàng cần xử lý</h6>
        </div>
        <div class="card-body">
            <div class="row align-items-end">
                <div class="col-md-3 mb-3">
                    <label for="user_id" class="form-label">Nhân viên bán hàng:</label>
                    <select id="user_id" name="user_id" data-placeholder="-- Chọn nhân viên --">
                        <option value=""></option>
                        <?php foreach ($users as $user): ?>
                            <option value="<?php echo $user['id']; ?>">
                                <?php echo htmlspecialchars($user['display_name'] ? $user['display_name'] : $user['username']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label for="order_date_original" class="form-label">Ngày bán hàng:</label>
                    <input type="text" id="order_date_original" class="form-control" placeholder="Chọn ngày bán">
                </div>
                <div class="col-md-4 mb-3">
                    <label for="customer_name_search" class="form-label">Tên khách hàng:</label>
                    <input type="text" id="customer_name_search" class="form-control" placeholder="Nhập tên khách hàng để lọc (tùy chọn)...">
                </div>
                <div class="col-md-2 mb-3">
                    <button type="button" id="viewOrdersBtn" class="btn btn-primary w-100">
                        <i class="fas fa-search fa-sm mr-2"></i> Xem đơn hàng
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <div id="results-container">
        </div>
</div>

<?php include __DIR__ . '/../../templates/footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://npmcdn.com/flatpickr/dist/l10n/vn.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    // Khởi tạo thư viện cho bộ lọc
    $('#user_id').select2({ theme: "bootstrap-5", allowClear: true });
    flatpickr('#order_date_original', {
        locale: "vn",
        altInput: true,
        altFormat: "d/m/Y",
        dateFormat: "Y-m-d",
        defaultDate: "today"
    });

    $('#viewOrdersBtn').on('click', function() {
        var button = $(this);
        var userId = $('#user_id').val();
        var originalDate = $('#order_date_original').val();
        var customerName = $('#customer_name_search').val();

        if (!userId || !originalDate) {
            alert('Vui lòng chọn nhân viên và ngày bán hàng.');
            return;
        }

        button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Đang tải...');
        $('#results-container').html('<div class="text-center mt-4"><div class="spinner-border text-primary" role="status"></div></div>');
        
        $.ajax({
            url: 'ajax_handler.php',
            type: 'POST',
            data: {
                action: 'get_orders_for_consolidation',
                user_id: userId,
                order_date_original: originalDate,
                customer_name: customerName
            },
            success: function(response) {
                $('#results-container').html(response);
                // Khởi tạo lại date/time picker cho các input mới được tải
                flatpickr('#new_delivery_date', {
                     locale: "vn", altInput: true, altFormat: "d/m/Y", dateFormat: "Y-m-d", defaultDate: "today"
                });
                flatpickr('#new_delivery_time', {
                    enableTime: true, noCalendar: true, dateFormat: "H:i", time_24hr: true, defaultDate: "09:00"
                });
            },
            error: function(xhr) {
                $('#results-container').html(`<div class="alert alert-danger mt-4">Đã có lỗi xảy ra khi tải dữ liệu. Vui lòng kiểm tra lại. <br><small>${xhr.responseText}</small></div>`);
            },
            complete: function() {
                button.prop('disabled', false).html('<i class="fas fa-search fa-sm mr-2"></i> Xem đơn hàng');
            }
        });
    });

    $(document).on('click', '#processBtn', function() {
        var button = $(this);
        var selectedOrders = [];
        $('#orders-list-table tbody input[type="checkbox"]:checked').each(function() {
            selectedOrders.push($(this).val());
        });

        if (selectedOrders.length === 0) {
            alert('Vui lòng chọn ít nhất một đơn hàng để xử lý.');
            return;
        }
        
        var newDate = $('#new_delivery_date').val();
        var newTime = $('#new_delivery_time').val();

        if (!newDate || !newTime) {
            alert('Vui lòng chọn ngày và giờ mới.');
            return;
        }

        if (!confirm('Bạn có chắc chắn muốn gộp và cập nhật ngày giờ cho các đơn hàng đã chọn không?')) {
            return;
        }
        
        button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Đang xử lý...');

        $.ajax({
            url: 'ajax_handler.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'update_and_consolidate',
                selected_order_ids: selectedOrders,
                new_order_date: newDate,
                new_order_time: newTime
            },
            success: function(response) {
                if (response.status === 'success') {
                    var printUrl = 'print_consolidated.php?code=' + response.consolidated_code;
                    var successMessage = `
                        <div class="card shadow mt-4">
                            <div class="card-body text-center p-5">
                                <h4 class="text-success"><i class="fas fa-check-circle fa-2x mb-3"></i></h4>
                                <h4>Thành công!</h4>
                                <p>${response.message}</p>
                                <p>Mã phiếu tổng hợp: <strong>${response.consolidated_code}</strong></p>
                                <a href="${printUrl}" target="_blank" class="btn btn-primary"><i class="fas fa-print mr-1"></i> Mở trang in phiếu</a>
                                <button onclick="location.reload();" class="btn btn-secondary">Thực hiện lại</button>
                            </div>
                        </div>`;
                    $('#results-container').html(successMessage);
                } else {
                    alert('Lỗi: ' + (response.message || 'Không thể xử lý.'));
                    button.prop('disabled', false).html('<i class="fas fa-check-circle mr-1"></i> Cập nhật và Gộp phiếu');
                }
            },
            error: function(xhr) {
                alert('Đã có lỗi không xác định xảy ra. Vui lòng thử lại. Lỗi server: ' + xhr.responseText);
                button.prop('disabled', false).html('<i class="fas fa-check-circle mr-1"></i> Cập nhật và Gộp phiếu');
            }
        });
    });

    $(document).on('change', '#checkAllOrders', function() {
        $('#orders-list-table tbody input[type="checkbox"]').prop('checked', $(this).prop('checked'));
    });
});
</script>