<?php
require_once __DIR__ . '/../../core/init.php';

if (empty($_GET['code'])) {
    die('Không tìm thấy mã phiếu in.');
}

$consolidated_code = $_GET['code'];

// Lấy thông tin chung cho phiếu in (ví dụ ngày giao)
$info_stmt = $conn->prepare("SELECT delivery_date, user_init FROM cms_orders WHERE consolidated_code = ? LIMIT 1");
$info_stmt->bind_param('s', $consolidated_code);
$info_stmt->execute();
$info_result = $info_stmt->get_result()->fetch_assoc();
$delivery_date_display = date('d/m/Y', strtotime($info_result['delivery_date']));

// ----- PHẦN 1: LẤY DANH SÁCH CÁC ĐƠN HÀNG -----
$orders_stmt = $conn->prepare("
    SELECT id, order_code, customer_name, total_quantity, total_money 
    FROM cms_orders 
    WHERE consolidated_code = ?
");
$orders_stmt->bind_param('s', $consolidated_code);
$orders_stmt->execute();
$orders_result = $orders_stmt->get_result();


// ----- PHẦN 2: TỔNG HỢP CHI TIẾT SẢN PHẨM TỪ TẤT CẢ ĐƠN HÀNG -----
$products_summary = [];
$all_orders_stmt = $conn->prepare("SELECT detail_order FROM cms_orders WHERE consolidated_code = ?");
$all_orders_stmt->bind_param('s', $consolidated_code);
$all_orders_stmt->execute();
$all_orders_result = $all_orders_stmt->get_result();

while ($order_row = $all_orders_result->fetch_assoc()) {
    // Giả sử `detail_order` là một chuỗi JSON
    $details = json_decode($order_row['detail_order'], true);
    if (is_array($details)) {
        foreach ($details as $item) {
            $prd_id = $item['id']; // Dùng mã sản phẩm làm key
            if (!isset($products_summary[$prd_id])) {
                // Nếu sản phẩm chưa có trong danh sách tổng hợp, thêm mới
                $products_summary[$prd_id] = [
                    'prd_code' => $item['prd_code'],
                    'prd_name' => $item['prd_name'],
                    'price' => $item['price'],
                    'prd_quycach' => $item['prd_quycach'] ?? 1, // Quy cách đóng gói
                    'total_sl' => 0,
                ];
            }
            // Cộng dồn số lượng
            $products_summary[$prd_id]['total_sl'] += $item['quantity'];
        }
    }
}

?>

<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <title>Phiếu Giao Hàng Tổng Hợp - <?php echo $consolidated_code; ?></title>
    <style>
        /* Thêm các style cho trang in ở đây, ví dụ: */
        body { font-family: 'Times New Roman', serif; font-size: 12px; }
        .print-container { width: 800px; margin: auto; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid black; padding: 5px; text-align: center; }
        .text-left { text-align: left; }
        .text-right { text-align: right; }
        h1, h2, h3 { text-align: center; }
        @media print {
            body { -webkit-print-color-adjust: exact; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="print-container">
        <button class="no-print" onclick="window.print()">In Phiếu</button>
        
        <h1>PHIẾU GIAO HÀNG TỔNG HỢP</h1>
        <p style="text-align:center;">Ngày giao hàng: <strong><?php echo $delivery_date_display; ?></strong></p>
        <p style="text-align:center;">Mã phiếu: <strong><?php echo $consolidated_code; ?></strong></p>

        <h3>I. DANH SÁCH ĐƠN HÀNG CẦN GIAO</h3>
        <table>
            <thead>
                <tr>
                    <th>STT</th>
                    <th>Mã đơn hàng</th>
                    <th>Khách hàng</th>
                    <th>Tổng SL</th>
                    <th>Tổng tiền</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $stt = 1; 
                $total_qty_all = 0;
                $total_money_all = 0;
                while($order = $orders_result->fetch_assoc()): 
                    $total_qty_all += $order['total_quantity'];
                    $total_money_all += $order['total_money'];
                ?>
                <tr>
                    <td><?php echo $stt++; ?></td>
                    <td><?php echo htmlspecialchars($order['order_code']); ?></td>
                    <td class="text-left"><?php echo htmlspecialchars($order['customer_name']); ?></td>
                    <td><?php echo $order['total_quantity']; ?></td>
                    <td class="text-right"><?php echo number_format($order['total_money']); ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th colspan="3" class="text-right">Tổng cộng</th>
                    <th><?php echo $total_qty_all; ?></th>
                    <th class="text-right"><?php echo number_format($total_money_all); ?></th>
                </tr>
            </tfoot>
        </table>

        <h3>II. CHI TIẾT HÀNG HÓA</h3>
        <table>
            <thead>
                <tr>
                    <th>STT</th>
                    <th>Mã hàng</th>
                    <th class="text-left">Miêu tả</th>
                    <th>Quy cách</th>
                    <th>Thùng</th>
                    <th>Lẻ</th>
                    <th>Tổng SL</th>
                    <th>Giá lẻ</th>
                    <th>Thành tiền</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $stt_prd = 1;
                $grand_total_money = 0;
                foreach($products_summary as $product):
                    $quycach = (int)($product['prd_quycach'] ?? 1);
                    if ($quycach <= 0) $quycach = 1; // Tránh chia cho 0
                    
                    $thung = floor($product['total_sl'] / $quycach);
                    $le = $product['total_sl'] % $quycach;
                    $thanh_tien = $product['total_sl'] * $product['price'];
                    $grand_total_money += $thanh_tien;
                ?>
                <tr>
                    <td><?php echo $stt_prd++; ?></td>
                    <td><?php echo htmlspecialchars($product['prd_code']); ?></td>
                    <td class="text-left"><?php echo htmlspecialchars($product['prd_name']); ?></td>
                    <td><?php echo $quycach; ?></td>
                    <td><?php echo $thung; ?></td>
                    <td><?php echo $le; ?></td>
                    <td><strong><?php echo $product['total_sl']; ?></strong></td>
                    <td class="text-right"><?php echo number_format($product['price']); ?></td>
                    <td class="text-right"><strong><?php echo number_format($thanh_tien); ?></strong></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th colspan="8" class="text-right">Tổng cộng thành tiền</th>
                    <th class="text-right"><?php echo number_format($grand_total_money); ?></th>
                </tr>
            </tfoot>
        </table>
    </div>
</body>
</html>