<?php
/**
 * File: modules/customers/export_customers_csv.php
 * Hoàn chỉnh - Đã sửa lỗi "Undefined array key customer_group".
 */

require_once __DIR__ . '/../../core/init.php';

// --- 1. Lấy các điều kiện lọc từ URL (GET) ---
$search_term = $_GET['search_term'] ?? '';
$group_id = $_GET['group_id'] ?? '';

// --- 2. Xây dựng câu lệnh SQL dựa trên điều kiện lọc ---
$whereClauses = [];
$params = [];
$types = '';

if (!empty($search_term)) {
    $whereClauses[] = "(c.customer_code LIKE ? OR c.customer_name LIKE ? OR c.customer_phone LIKE ?)";
    $searchTermWildcard = "%" . $search_term . "%";
    array_push($params, $searchTermWildcard, $searchTermWildcard, $searchTermWildcard);
    $types .= 'sss';
}
if ($group_id !== '') {
    $whereClauses[] = "c.customer_group = ?";
    $params[] = $group_id;
    $types .= 'i';
}
$whereSql = count($whereClauses) > 0 ? " WHERE " . implode(" AND ", $whereClauses) : "";

// --- 3. Truy vấn toàn bộ dữ liệu phù hợp (không phân trang) ---
// Thêm 'c.customer_group' vào danh sách các cột cần lấy
$dataQuery = "SELECT 
                c.customer_code, c.customer_name, c.customer_group, g.group_name, c.customer_phone, c.customer_email, c.customer_addr,
                (SELECT SUM(o.total_money) FROM cms_orders o WHERE o.customer_id = c.ID) as total_revenue,
                (SELECT SUM(o.lack) FROM cms_orders o WHERE o.customer_id = c.ID) as total_debt
              FROM cms_customers c
              LEFT JOIN cms_customers_group g ON c.customer_group = g.ID"
           . $whereSql
           . " ORDER BY c.customer_name ASC";

$stmt = $conn->prepare($dataQuery);
if ($stmt) {
    if (!empty($types)) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $result = $stmt->get_result();
}

// --- 4. Tạo và xuất file CSV ---
$filename = "danhsach_khachhang_" . date('Ymd') . ".csv";

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');

$output = fopen('php://output', 'w');

// Thêm BOM để Excel đọc UTF-8 (Tiếng Việt) đúng
fputs($output, "\xEF\xBB\xBF");

// Viết dòng tiêu đề
fputcsv($output, [
    'Mã KH', 'Tên Khách Hàng', 'Nhóm', 'Điện Thoại', 'Email', 
    'Địa Chỉ', 'Tổng Mua', 'Còn Nợ'
]);

// Viết dữ liệu
if (isset($result) && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        // Logic xác định tên nhóm giờ sẽ hoạt động chính xác
        $group_display_name = '';
        if (!empty($row['group_name'])) {
            $group_display_name = $row['group_name'];
        } else {
            $group_display_name = ($row['customer_group'] == 0) ? 'Khách sỉ' : 'Khách lẻ';
        }
        
        fputcsv($output, [
            $row['customer_code'],
            $row['customer_name'],
            $group_display_name,
            $row['customer_phone'],
            $row['customer_email'],
            $row['customer_addr'],
            $row['total_revenue'] ?? 0,
            $row['total_debt'] ?? 0
        ]);
    }
}

fclose($output);
$conn->close();
exit();