<?php
require_once __DIR__ . '/../../templates/header.php';

$status_map = [
    0 => ['text' => 'Đã hủy', 'class' => 'badge-danger'],
    1 => ['text' => 'Hoàn thành', 'class' => 'badge-success'],
    2 => ['text' => 'Đang giao', 'class' => 'badge-info'],
    3 => ['text' => 'Xác nhận', 'class' => 'badge-primary'],
];

$order_id = intval($_GET['id'] ?? 0);
if ($order_id <= 0) { die("Đơn hàng không hợp lệ."); }

$sql = "SELECT 
            o.*, 
            c.customer_name, c.customer_phone, c.customer_addr,
            u.username as user_created
        FROM cms_orders o
        JOIN cms_customers c ON o.customer_id = c.ID
        LEFT JOIN cms_users u ON o.user_init = u.id
        WHERE o.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$order) { die("Không tìm thấy đơn hàng."); }
$order_items = json_decode($order['detail_order'], true);

// *** LOGIC MỚI: LẤY THÔNG TIN CHI TIẾT SẢN PHẨM ĐỂ HỖ TRỢ ĐƠN HÀNG CŨ ***
$product_ids = array_map(function($item) { return $item['id']; }, $order_items);
$products_data = [];
if (!empty($product_ids)) {
    $sql_products = "SELECT id, prd_code, prd_name FROM cms_products WHERE id IN (". implode(',', array_fill(0, count($product_ids), '?')) .")";
    $stmt_products = $conn->prepare($sql_products);
    $stmt_products->bind_param(str_repeat('i', count($product_ids)), ...$product_ids);
    $stmt_products->execute();
    $result = $stmt_products->get_result();
    while ($row = $result->fetch_assoc()) {
        $products_data[$row['id']] = $row;
    }
    $stmt_products->close();
}
?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Đơn hàng » <?php echo htmlspecialchars($order['output_code']); ?></h1>
        <div><a href="list.php" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left fa-sm"></i> Quay lại</a></div>
    </div>
    
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <div class="d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-primary">Chi tiết đơn hàng</h6>
                <div>
                    <button class="btn btn-primary btn-sm btn-update-status" data-status="3">Xác nhận</button>
                    <button class="btn btn-info btn-sm btn-update-status" data-status="2">Đang giao</button>
                    <button class="btn btn-success btn-sm btn-update-status" data-status="1">Hoàn thành</button>
                    <button class="btn btn-danger btn-sm btn-update-status" data-status="0">Hủy</button>
                    <a href="/quanlybanhang/modules/pos/print_invoice.php?order_id=<?php echo $order_id; ?>" target="_blank" class="btn btn-secondary btn-sm">In đơn hàng</a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-8">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr><th>STT</th><th>Mã hàng</th><th>Tên sản phẩm</th><th>Số lượng</th><th>Đơn giá</th><th>Thành tiền</th></tr>
                            </thead>
                            <tbody>
                                <?php $stt = 1; foreach($order_items as $item): 
                                    // Lấy thông tin sản phẩm từ mảng đã tra cứu
                                    $product_info = $products_data[$item['id']] ?? ['prd_code' => 'N/A', 'prd_name' => 'Sản phẩm không tồn tại'];
                                    
                                    // Ưu tiên dữ liệu lưu trong đơn, nếu không có thì dùng dữ liệu vừa tra cứu
                                    $item_code = $item['code'] ?? $product_info['prd_code'];
                                    $item_name = $item['name'] ?? $product_info['prd_name'];
                                ?>
                                <tr>
                                    <td><?php echo $stt++; ?></td>
                                    <td><?php echo htmlspecialchars($item_code); ?></td>
                                    <td><?php echo htmlspecialchars($item_name); ?></td>
                                    <td class="text-center"><?php echo $item['quantity']; ?></td>
                                    <td class="text-right"><?php echo number_format($item['price']); ?></td>
                                    <td class="text-right"><?php echo number_format($item['quantity'] * $item['price']); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="col-md-4">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between"><strong>Mã phiếu:</strong><span><?php echo htmlspecialchars($order['output_code']); ?></span></li>
                        <li class="list-group-item d-flex justify-content-between"><strong>Trạng thái:</strong>
                            <?php
                                $status_val = $order['order_status'];
                                $status_display = $status_map[$status_val] ?? ['text' => 'Không xác định', 'class' => 'badge-secondary'];
                                echo "<span id='order-status-text' class='badge {$status_display['class']}'>{$status_display['text']}</span>";
                            ?>
                        </li>
                        <li class="list-group-item d-flex justify-content-between"><strong>Khách hàng:</strong><span><?php echo htmlspecialchars($order['customer_name']); ?></span></li>
                        <li class="list-group-item d-flex justify-content-between"><strong>Ngày bán:</strong><span><?php echo date('d/m/Y H:i', strtotime($order['sell_date'])); ?></span></li>
                        <li class="list-group-item d-flex justify-content-between"><strong>NV bán hàng:</strong><span><?php echo htmlspecialchars($order['user_created'] ?? 'N/A'); ?></span></li>
                        <li class="list-group-item"><p class="mb-0"><strong>Ghi chú:</strong> <?php echo nl2br(htmlspecialchars($order['notes'])); ?></p></li>
                    </ul>
                    <hr>
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between"><strong>Tổng cộng:</strong><span class="font-weight-bold"><?php echo number_format($order['total_money']); ?></span></li>
                        <li class="list-group-item d-flex justify-content-between"><strong>Khách trả:</strong><span class="font-weight-bold text-primary"><?php echo number_format($order['customer_pay']); ?></span></li>
                        <li class="list-group-item d-flex justify-content-between"><strong>Còn nợ:</strong><span class="font-weight-bold text-danger"><?php echo number_format($order['lack']); ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>

<script>
$(document).ready(function() {
    $('.btn-update-status').on('click', function(e) {
        e.preventDefault();
        const newStatusCode = $(this).data('status');
        const newStatusText = $(this).text();
        const orderId = <?php echo $order_id; ?>;
        const confirmMessage = newStatusCode === 0 
            ? 'Bạn có chắc chắn muốn HỦY đơn hàng này? Thao tác này sẽ hoàn trả tồn kho và không thể hoàn tác!'
            : `Bạn có chắc chắn muốn cập nhật trạng thái thành "${newStatusText}"?`;

        if (confirm(confirmMessage)) {
            $.ajax({
                url: '/quanlybanhang/ajax/orders_ajax.php',
                type: 'POST',
                data: {
                    action: 'update_order_status',
                    order_id: orderId,
                    new_status: newStatusCode
                },
                dataType: 'json',
                success: function(response) {
                    alert(response.message);
                    if (response.status === 'success') {
                        location.reload();
                    }
                },
                error: function() {
                    alert('Lỗi kết nối, không thể cập nhật trạng thái.');
                }
            });
        }
    });
});
</script>