<?php
require_once __DIR__ . '/../../core/init.php';

// --- LẤY DỮ LIỆU PHIẾU SOẠN ---
$picking_slip_id = intval($_GET['id'] ?? 0);
if ($picking_slip_id <= 0) { die('ID phiếu soạn hàng không hợp lệ.'); }

$stmt_slip = $conn->prepare("SELECT ps.*, u.username FROM cms_output ps JOIN cms_users u ON ps.user_init = u.id WHERE ps.ID = ?");
$stmt_slip->bind_param("i", $picking_slip_id);
$stmt_slip->execute();
$slip = $stmt_slip->get_result()->fetch_assoc();
$stmt_slip->close();

if (!$slip) { die('Không tìm thấy phiếu soạn hàng.'); }

// Đọc dữ liệu JSON từ phiếu soạn
$orders_snapshot = json_decode($slip['detail_order_id'], true) ?: [];
$products_snapshot = json_decode($slip['detail_product_id'], true) ?: [];


// === LOGIC MỚI HOÀN CHỈNH KẾT HỢP ===

// 1. LẤY DANH SÁCH ĐƠN HÀNG ĐỂ HIỂN THỊ (BẢNG I)
$live_orders_to_print = [];
// Sửa lỗi: Xử lý cả key 'id' và 'order_id' để tương thích dữ liệu cũ
$order_ids = array_map(function($item) {
    return is_array($item) ? ($item['id'] ?? $item['order_id'] ?? null) : null;
}, $orders_snapshot);
$order_ids = array_filter(array_unique($order_ids), 'is_numeric');

if (!empty($order_ids)) {
    $placeholders = implode(',', array_fill(0, count($order_ids), '?'));
    $sql_live = "SELECT o.id, o.output_code, o.total_quantity, o.total_money, 
                         c.customer_name, c.customer_phone, c.customer_addr 
                  FROM cms_orders o 
                  LEFT JOIN cms_customers c ON o.customer_id = c.id 
                  WHERE o.id IN ($placeholders) AND o.deleted = 0";

    $stmt_live = $conn->prepare($sql_live);
    if ($stmt_live) {
        $stmt_live->bind_param(str_repeat('i', count($order_ids)), ...$order_ids);
        $stmt_live->execute();
        $live_orders_to_print = $stmt_live->get_result()->fetch_all(MYSQLI_ASSOC);
        $stmt_live->close();
    }
}

// 2. TỔNG HỢP VÀ LẤY THÔNG TIN SẢN PHẨM (BẢNG II)
$consolidated_items_display = [];
$consolidated_items_map = [];

// Bước 2.1: Tổng hợp số lượng từ snapshot chi tiết
if (is_array($products_snapshot)) {
    foreach ($products_snapshot as $item) {
        $product_id = intval($item['id'] ?? 0);
        $quantity = floatval($item['quantity'] ?? 0);
        if ($product_id > 0 && $quantity > 0) {
            $consolidated_items_map[$product_id] = ($consolidated_items_map[$product_id] ?? 0) + $quantity;
        }
    }
}

if (!empty($consolidated_items_map)) {
    $product_ids_to_fetch = array_keys($consolidated_items_map);
    $products_info_map = [];
    
    if(!empty($product_ids_to_fetch)){
        // Bước 2.2: Truy vấn thông tin của các sản phẩm đã tổng hợp
        $sql_products = "SELECT id, prd_code, prd_name, prd_quycach FROM cms_products WHERE id IN (". implode(',', array_fill(0, count($product_ids_to_fetch), '?')) .")";
        $stmt_products = $conn->prepare($sql_products);
        if ($stmt_products) {
            $stmt_products->bind_param(str_repeat('i', count($product_ids_to_fetch)), ...$product_ids_to_fetch);
            $stmt_products->execute();
            $products_result = $stmt_products->get_result();
            while ($product = $products_result->fetch_assoc()) { 
                $products_info_map[$product['id']] = $product; 
            }
            $stmt_products->close();
        }
    }
    
    // Bước 2.3: Xây dựng mảng hiển thị cuối cùng
    foreach($consolidated_items_map as $product_id => $quantity) {
        $product_info = $products_info_map[$product_id] ?? null;

        $consolidated_items_display[] = [
            'code'      => $product_info['prd_code'] ?? 'N/A',
            'name'      => $product_info['prd_name'] ?? 'Sản phẩm đã bị xóa hoặc không xác định',
            'spec'      => $product_info['prd_quycach'] ?? 0,
            'quantity'  => $quantity,
        ];
    }

    // === BẮT ĐẦU ĐOẠN CODE SẮP XẾP MỚI ===
    // Sắp xếp mảng consolidated_items_display theo tên sản phẩm (name) A-Z
    usort($consolidated_items_display, function($a, $b) {
        // So sánh tên sản phẩm một cách không phân biệt chữ hoa chữ thường
        return strcasecmp($a['name'], $b['name']);
    });
    // === KẾT THÚC ĐOẠN CODE SẮP XẾP MỚI ===
}
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <title>Phiếu soạn hàng <?php echo htmlspecialchars($slip['output_code'] ?? 'Chưa có mã'); ?></title>
    <style>
        body { font-family: 'Times New Roman', Times, serif; font-size: 11pt; margin: 0; background: #f0f0f0; }
        .page { background: white; width: 14.8cm; min-height: 21cm; padding: 1cm; margin: 1cm auto; box-shadow: 0 0 5px rgba(0,0,0,0.1); display: flex; flex-direction: column; }
        .main-content { flex-grow: 1; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; font-size: 9pt; }
        th, td { border: 1px solid #000; padding: 4px; text-align: center; vertical-align: middle; }
        .title { text-align: center; font-size: 15pt; font-weight: bold; margin: 15px 0; }
        .order-info { display: table; width: 100%; margin-bottom: 10px; border-bottom: 1px dashed #ccc; padding-bottom: 10px; line-height: 1.5; font-size: 11pt;}
        .order-info > div { display: table-cell; width: 50%; }
        .section-title { font-weight: bold; font-size: 12pt; text-align: center; margin-top: 20px; margin-bottom: 10px; }
        .text-left { text-align: left; } .text-right { text-align: right; }
        .footer { margin-top: auto; padding-top: 30px; display: flex; justify-content: space-around; text-align: center; font-weight: bold; font-size: 11pt;}
        .footer span { display: block; margin-top: 60px; font-style: italic; font-weight: normal; font-size: 10pt; }
        .print-actions-container { display: none; }
        @media screen { .print-actions-container { display: block; text-align: center; padding: 20px; } }
        @media print { body, .page { margin: 0; padding: 0.8cm; box-shadow: none; border: none; background: white; } }
    </style>
</head>
<body>
    <div class="page">
        <?php require_once __DIR__ . '/../../templates/print_header_template.php'; ?>
        
        <div class="main-content">
            <h1 class="title">PHIẾU SOẠN HÀNG</h1>
            <div class="order-info">
                <div><p><strong>Nhân viên bán hàng:</strong> <?php echo htmlspecialchars($slip['username']); ?></p></div>
                <div style="text-align: right;"><p><strong>Ngày bán:</strong> <?php echo date('d/m/Y', strtotime($slip['date_order'])); ?></p></div>
            </div>
            <div class="section-title">I. DANH SÁCH ĐƠN HÀNG CẦN GIAO</div>
            <table>
                <thead><tr><th>STT</th><th>Mã đơn hàng</th><th class="text-left">Khách hàng</th><th class="text-left">Địa chỉ</th><th class="text-right">Tổng SL</th><th class="text-right">Tổng tiền</th></tr></thead>
                <tbody>
                    <?php if(empty($live_orders_to_print)): ?>
                        <tr><td colspan="6" class="text-center">Không có đơn hàng hợp lệ để hiển thị.</td></tr>
                    <?php else: ?>
                        <?php $stt = 1; $total_amount_sum = 0; $total_qty_sum = 0; foreach($live_orders_to_print as $order): ?>
                            <tr>
                                <td><?php echo $stt++; ?></td>
                                <td><?php echo htmlspecialchars($order['output_code'] ?? 'N/A'); ?></td>
                                <td class="text-left"><?php echo htmlspecialchars($order['customer_name'] ?? 'Không rõ'); ?></td>
                                <td class="text-left"><?php echo htmlspecialchars($order['customer_addr'] ?? ''); ?></td>
                                <td class="text-right"><?php $total_qty_sum += ($order['total_quantity'] ?? 0); echo number_format($order['total_quantity'] ?? 0); ?></td>
                                <td class="text-right"><?php $total_amount_sum += ($order['total_money'] ?? 0); echo number_format($order['total_money'] ?? 0); ?></td>
                            </tr>
                        <?php endforeach; ?>
                        <tr>
                            <td colspan="4" class="text-right"><strong>Tổng cộng</strong></td>
                            <td class="text-right"><strong><?php echo number_format($total_qty_sum); ?></strong></td>
                            <td class="text-right"><strong><?php echo number_format($total_amount_sum); ?></strong></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <div class="section-title">II. DANH SÁCH SẢN PHẨM CẦN LẤY</div>
            <table>
                    <thead>
                        <tr><th rowspan="2">STT</th><th rowspan="2">Mã hàng</th><th rowspan="2" class="text-left">Miêu tả</th><th rowspan="2">Quy cách</th><th colspan="2">Số lượng tổng</th><th rowspan="2">Ghi chú</th></tr>
                        <tr><th>Thùng</th><th>Lẻ</th></tr>
                    </thead>
                    <tbody>
                        <?php if(empty($consolidated_items_display)): ?>
                            <tr><td colspan="7">Không có sản phẩm nào.</td></tr>
                        <?php else: ?>
                            <?php $stt = 1; foreach ($consolidated_items_display as $item): 
                                 $spec_size = intval($item['spec'] ?? 0);
                                 $quantity = floatval($item['quantity'] ?? 0);
                                 $packs = ($spec_size > 0) ? floor($quantity / $spec_size) : 0;
                                 $loose = ($spec_size > 0) ? fmod($quantity, $spec_size) : $quantity;
                             ?>
                            <tr>
                                <td><?php echo $stt++; ?></td>
                                <td><?php echo htmlspecialchars($item['code']); ?></td>
                                <td class="text-left"><?php echo htmlspecialchars($item['name']); ?></td>
                                <td><?php echo $spec_size > 0 ? $spec_size : ''; ?></td>
                                <td><?php echo $packs > 0 ? number_format($packs) : ''; ?></td>
                                <td><?php echo $loose > 0 ? number_format($loose, 0) : ''; ?></td>
                                <td></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <footer class="footer">
                <div>Người lập phiếu<span><?php echo htmlspecialchars($slip['username']); ?></span></div>
                <div>Nhân viên giao hàng<span>(Ký, ghi rõ họ tên)</span></div>
            </footer>
        </div>
        <div class="print-actions-container" style="text-align:center; padding: 20px;">
            <a href="list.php" style="padding: 10px 20px; background-color: #6c757d; color: white; text-decoration: none; border-radius: 5px;">Trở lại</a>
            <button onclick="window.print()" style="padding: 10px 20px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer;">In Phiếu</button>
        </div>
</body>
</html>