<?php
// File này chỉ chạy một lần để sửa dữ liệu cũ, sau đó có thể xóa đi.
require_once __DIR__ . '/../../core/init.php';
header('Content-Type: text/html; charset=utf-8');

echo "<h1>Bắt đầu quá trình sửa chữa phiếu soạn hàng cũ...</h1>";
echo "<p>Vui lòng chờ. Quá trình có thể mất vài giây.</p>";
echo "<hr>";
echo "<pre>"; // Dùng thẻ <pre> để hiển thị log cho dễ đọc

// Lấy tất cả các phiếu soạn hàng
$slips_result = $conn->query("SELECT ID, detail_order_id, detail_product_id FROM cms_output ORDER BY ID ASC");
if (!$slips_result) {
    die("Lỗi: Không thể truy vấn danh sách phiếu.");
}

$slips_to_process = $slips_result->fetch_all(MYSQLI_ASSOC);
$slips_repaired_count = 0;

foreach ($slips_to_process as $slip) {
    $slip_id = $slip['ID'];
    $orders_json = $slip['detail_order_id'];
    $products_json = $slip['detail_product_id'];
    $orders_data = json_decode($orders_json, true);
    $products_data = json_decode($products_json, true);

    echo "Đang xử lý Phiếu ID: $slip_id... ";

    // Kiểm tra xem phiếu này có cần sửa không (dựa vào định dạng của detail_product_id)
    $first_product_item = is_array($products_data) ? reset($products_data) : null;
    if (is_array($products_data) && !is_array($first_product_item)) { // Đây là định dạng cũ [product_id => quantity]
        echo "Phát hiện định dạng cũ. Đang tiến hành sửa chữa...<br>";

        // Trích xuất ID đơn hàng từ định dạng cũ
        $order_ids = array_column($orders_data ?: [], 'id');
        $order_ids = array_filter($order_ids, 'is_numeric');

        if (empty($order_ids)) {
            echo "   -> Không tìm thấy ID đơn hàng hợp lệ. Bỏ qua.<br>";
            continue;
        }

        // === THAY ĐỔI START: Lấy thông tin chi tiết của tất cả sản phẩm trong các đơn hàng ===
        $ids_placeholder = implode(',', array_fill(0, count($order_ids), '?'));
        $sql_orders = "SELECT o.detail_order FROM cms_orders o WHERE o.id IN ($ids_placeholder)";
        $stmt_fetch = $conn->prepare($sql_orders);
        $stmt_fetch->bind_param(str_repeat('i', count($order_ids)), ...$order_ids);
        $stmt_fetch->execute();
        $fetched_orders_result = $stmt_fetch->get_result();
        
        $product_info_snapshot = [];
        while($order_row = $fetched_orders_result->fetch_assoc()){
             $items = json_decode($order_row['detail_order'], true);
             if (is_array($items)) {
                foreach($items as $item) {
                    $product_id = intval($item['id'] ?? 0);
                    if ($product_id > 0 && !isset($product_info_snapshot[$product_id])) {
                        // Lưu lại bản chụp thông tin sản phẩm
                        $product_info_snapshot[$product_id] = [
                            'code' => $item['code'] ?? 'N/A',
                            'name' => $item['name'] ?? 'Không xác định'
                        ];
                    }
                }
             }
        }
        $stmt_fetch->close();
        // === THAY ĐỔI END ===


        // Tạo lại map sản phẩm với đầy đủ thông tin (mã, tên, số lượng)
        $new_consolidated_items_map = [];
        foreach($products_data as $product_id => $quantity) {
             $info = $product_info_snapshot[$product_id] ?? ['code' => 'N/A', 'name' => 'Sản phẩm đã bị xóa'];
             $new_consolidated_items_map[$product_id] = [
                 'code' => $info['code'],
                 'name' => $info['name'],
                 'quantity' => $quantity
             ];
        }

        // Cập nhật lại cột detail_product_id với cấu trúc JSON mới
        $new_products_json = json_encode($new_consolidated_items_map);
        $stmt_update = $conn->prepare("UPDATE cms_output SET detail_product_id = ? WHERE ID = ?");
        $stmt_update->bind_param("si", $new_products_json, $slip_id);
        $stmt_update->execute();
        
        if ($stmt_update->affected_rows > 0) {
            echo "   -> **ĐÃ SỬA CHỮA THÀNH CÔNG!**<br>";
            $slips_repaired_count++;
        } else {
            echo "   -> Không có gì thay đổi hoặc lỗi cập nhật.<br>";
        }
        $stmt_update->close();

    } else {
        echo "Phiếu có định dạng mới hoặc rỗng. Bỏ qua.<br>";
    }
}

echo "</pre>";
echo "<hr>";
echo "<h2>Hoàn tất! Đã sửa chữa thành công $slips_repaired_count phiếu.</h2>";
echo '<p>Bây giờ bạn có thể quay lại trang danh sách và thử in lại các phiếu cũ.</p>';
echo '<a href="list.php">Quay về trang danh sách</a>';
?>