<?php
require_once __DIR__ . '/../../core/init.php';
require_once __DIR__ . '/../../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Câu lệnh SQL không thay đổi
$sql = "SELECT 
            p.prd_name, p.prd_code, p.prd_sls AS prd_inventory, p.prd_origin_price, p.prd_sell_price, 
            p.prd_sell_price2, g.prd_group_name, m.prd_manuf_name, u.prd_unit_name, p.prd_tenquycach, p.prd_quycach
        FROM cms_products p 
        LEFT JOIN cms_products_group g ON p.prd_group_id = g.id 
        LEFT JOIN cms_products_manufacture m ON p.prd_manufacture_id = m.id
        LEFT JOIN cms_products_unit u ON p.prd_unit_id = u.id
        WHERE p.deleted = 0
        ORDER BY p.id DESC";
$result = $conn->query($sql);

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setTitle('Danh Sach San Pham');

// --- THAY ĐỔI 1: Thêm tiêu đề cho 2 cột mới ---
// Thiết lập tiêu đề
$sheet->setCellValue('A1', 'Tên sản phẩm');
$sheet->setCellValue('B1', 'Mã sản phẩm');
$sheet->setCellValue('C1', 'Tồn kho');
$sheet->setCellValue('D1', 'Giá vốn');
$sheet->setCellValue('E1', 'Giá bán lẻ');
$sheet->setCellValue('F1', 'Giá bán sỉ');
$sheet->setCellValue('G1', 'Danh mục');
$sheet->setCellValue('H1', 'Nhà sản xuất');
$sheet->setCellValue('I1', 'Đơn vị tính');
$sheet->setCellValue('J1', 'Tên quy cách');
$sheet->setCellValue('K1', 'Quy cách');
$sheet->setCellValue('L1', 'Thùng'); // Cột mới
$sheet->setCellValue('M1', 'Lẻ');   // Cột mới

// --- THAY ĐỔI 2: Mở rộng vùng in đậm cho tiêu đề ---
// In đậm tiêu đề
$sheet->getStyle('A1:M1')->getFont()->setBold(true);

$rowIndex = 2;
if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $sheet->setCellValue('A' . $rowIndex, $row['prd_name']);
        $sheet->setCellValue('B' . $rowIndex, $row['prd_code']);
        $sheet->setCellValue('C' . $rowIndex, $row['prd_inventory']);
        $sheet->setCellValue('D' . $rowIndex, $row['prd_origin_price']);
        $sheet->setCellValue('E' . $rowIndex, $row['prd_sell_price']);
        $sheet->setCellValue('F' . $rowIndex, $row['prd_sell_price2']);
        $sheet->setCellValue('G' . $rowIndex, $row['prd_group_name']);
        $sheet->setCellValue('H' . $rowIndex, $row['prd_manuf_name']);
        $sheet->setCellValue('I' . $rowIndex, $row['prd_unit_name']);
        $sheet->setCellValue('J' . $rowIndex, $row['prd_tenquycach']);
        $sheet->setCellValue('K' . $rowIndex, $row['prd_quycach']);

        // --- THAY ĐỔI 3: Tính toán và điền dữ liệu cho cột Thùng và Lẻ ---
        $inventory = (int)$row['prd_inventory'];
        $quycach = (int)$row['prd_quycach'];
        
        $thung = 0;
        $le = 0;

        // Chỉ tính toán khi quy cách > 0 để tránh lỗi chia cho 0
        if ($quycach > 0) {
            $thung = floor($inventory / $quycach); // Số thùng (làm tròn xuống)
            $le = $inventory % $quycach;           // Số lẻ còn lại
        } else {
            // Nếu không có quy cách, coi như không có thùng và tồn kho là số lẻ
            $thung = 0;
            $le = $inventory;
        }

        $sheet->setCellValue('L' . $rowIndex, $thung);
        $sheet->setCellValue('M' . $rowIndex, $le);

        $rowIndex++;
    }
}

// --- THAY ĐỔI 4: Mở rộng vùng tự động giãn cột ---
// Tự động giãn cột
foreach (range('A', 'M') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

// Thiết lập header để trình duyệt hiểu và tải file về (không thay đổi)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="danh_sach_san_pham.xlsx"');
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
?>