<?php
require_once __DIR__ . '/../../core/init.php';
require_once __DIR__ . '/../../includes/receipt_helpers.php';

$receipt_id = intval($_GET['id'] ?? 0);
if ($receipt_id <= 0) {
    die("ID phiếu thu không hợp lệ.");
}

$sql = "SELECT r.*, c.customer_name, c.customer_addr, u.display_name as user_name
        FROM cms_receipt r
        LEFT JOIN cms_orders o ON r.order_id = o.ID
        LEFT JOIN cms_customers c ON o.customer_id = c.ID
        LEFT JOIN cms_users u ON r.user_init = u.ID
        WHERE r.ID = ?";

$stmt = $conn->prepare($sql);
if ($stmt === false) {
    die("Lỗi chuẩn bị câu lệnh SQL: " . $conn->error);
}
$stmt->bind_param('i', $receipt_id);
$stmt->execute();
$receipt = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$receipt) {
    die("Không tìm thấy phiếu thu.");
}

$receipt_types = get_receipt_types();
$receipt_type_name = $receipt_types[$receipt['type_id']] ?? 'Không xác định';

// Hàm chuyển số thành chữ (giữ nguyên)
function number_to_words_vietnamese($number) {
    $hyphen      = ' '; $conjunction = ' '; $separator   = ' '; $negative    = 'âm '; $decimal     = ' phẩy ';
    $dictionary  = array(0 => 'không', 1 => 'một', 2 => 'hai', 3 => 'ba', 4 => 'bốn', 5 => 'năm', 6 => 'sáu', 7 => 'bảy', 8 => 'tám', 9 => 'chín', 10 => 'mười', 11 => 'mười một', 12 => 'mười hai', 13 => 'mười ba', 14 => 'mười bốn', 15 => 'mười lăm', 16 => 'mười sáu', 17 => 'mười bảy', 18 => 'mười tám', 19 => 'mười chín', 20 => 'hai mươi', 30 => 'ba mươi', 40 => 'bốn mươi', 50 => 'năm mươi', 60 => 'sáu mươi', 70 => 'bảy mươi', 80 => 'tám mươi', 90 => 'chín mươi', 100 => 'trăm', 1000 => 'nghìn', 1000000 => 'triệu', 1000000000 => 'tỷ');
    if (!is_numeric($number)) { return false; }
    if ($number < 0) { return $negative . number_to_words_vietnamese(abs($number)); }
    $string = $fraction = null;
    if (strpos($number, '.') !== false) { list($number, $fraction) = explode('.', $number); }
    switch (true) {
        case $number < 21: $string = $dictionary[$number]; break;
        case $number < 100:
            $tens   = ((int) ($number / 10)) * 10;
            $units  = $number % 10;
            $string = $dictionary[$tens];
            if ($units) { $string .= $hyphen . ($units == 1 ? 'mốt' : ($units == 5 ? 'lăm' : $dictionary[$units])); }
            break;
        case $number < 1000:
            $hundreds  = floor($number / 100);
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) { $string .= $conjunction . ($remainder < 10 ? 'linh ' . number_to_words_vietnamese($remainder) : number_to_words_vietnamese($remainder)); }
            break;
        default:
            $baseUnit = pow(1000, floor(log($number, 1000)));
            $numBaseUnits = (int) ($number / $baseUnit);
            $remainder = $number % $baseUnit;
            $string = number_to_words_vietnamese($numBaseUnits) . ' ' . $dictionary[$baseUnit];
            if ($remainder) { $string .= $remainder < 100 ? ' không trăm ' . ($remainder < 10 ? 'linh ' : '') . number_to_words_vietnamese($remainder) : $conjunction . number_to_words_vietnamese($remainder); }
            break;
    }
    return ucfirst($string);
}
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <title>Phiếu thu - <?php echo htmlspecialchars($receipt['receipt_code']); ?></title>
    <style>
        body { font-family: 'Times New Roman', Times, serif; font-size: 13pt; margin: 0; background-color: #eee; }
        .page { 
            background: white; 
            width: 14.8cm; 
            min-height: 21cm; 
            padding: 1cm;
            margin: 1cm auto; 
            display: flex; 
            flex-direction: column; 
            box-shadow: 0 0 5px rgba(0,0,0,0.1); 
        }
        .main-content {
            flex-grow: 1;
        }
        .title-block {
            text-align: center;
            margin-bottom: 20px;
        }
        .title-block h1 {
            font-size: 18pt;
            font-weight: bold;
            margin: 0;
        }
        .title-block p {
            margin: 2px 0;
            font-style: italic;
        }
        .content-table {
            width: 100%;
            border-collapse: collapse;
            line-height: 1.8;
        }
        .content-table td {
            padding: 5px;
            vertical-align: top;
        }
        .content-table td:first-child {
            width: 150px;
            font-weight: bold;
        }
        .amount-in-words { 
            font-style: italic; 
        }
        .footer { 
            margin-top: 40px; 
            padding-top: 20px;
            display: flex; 
            justify-content: space-around; 
            text-align: center; 
            width: 100%;
        }
        .footer div { 
            font-weight: bold; 
        }
        .footer .signature { 
            margin-top: 60px; 
            font-style: italic; 
            font-weight: normal; 
        }
        @media print {
            body, .page { margin: 0; padding: 0.8cm; box-shadow: none; border: none; }
            .print-button { display: none; }
        }
    </style>
</head>
<body>
    <div class="page">
        <?php
            require_once __DIR__ . '/../../templates/print_header_template.php'; 
        ?>

        <div class="main-content">
            <div class="title-block">
                <h1>PHIẾU THU</h1>
                <p>Ngày <?php echo date('d', strtotime($receipt['receipt_date'])); ?> tháng <?php echo date('m', strtotime($receipt['receipt_date'])); ?> năm <?php echo date('Y', strtotime($receipt['receipt_date'])); ?></p>
                <p><strong>Số:</strong> <?php echo htmlspecialchars($receipt['receipt_code']); ?></p>
            </div>

            <table class="content-table">
                <tr>
                    <td>Họ tên người nộp:</td>
                    <td><?php echo htmlspecialchars($receipt['customer_name'] ?? 'Khách lẻ'); ?></td>
                </tr>
                <tr>
                    <td>Địa chỉ:</td>
                    <td><?php echo htmlspecialchars($receipt['customer_addr'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td>Lý do nộp:</td>
                    <td>
                        <?php 
                            // **THAY ĐỔI LOGIC HIỂN THỊ GHI CHÚ**
                            // Bắt đầu với lý do chính
                            $reason = $receipt_type_name;
                            // Nếu có ghi chú và ghi chú không phải là khoảng trắng, thì nối chuỗi ghi chú vào
                            if (!empty(trim($receipt['notes']))) {
                                $reason .= ' - ' . $receipt['notes'];
                            }
                            echo htmlspecialchars($reason);
                        ?>
                    </td>
                </tr>
                <tr>
                    <td>Số tiền:</td>
                    <td><strong><?php echo number_format($receipt['total_money'], 0, ',', '.'); ?> VNĐ</strong></td>
                </tr>
                <tr>
                    <td class="amount-in-words">Viết bằng chữ:</td>
                    <td class="amount-in-words"><?php echo htmlspecialchars(number_to_words_vietnamese($receipt['total_money'])); ?> đồng chẵn.</td>
                </tr>
            </table>
            </div>

        <div class="footer">
            <div>
                Người lập phiếu
                <div class="signature">
                    <?php echo htmlspecialchars($receipt['user_name']); ?>
                </div>
            </div>
            <div>
                Người nộp tiền
                <div class="signature">
                    (Ký, họ tên)
                </div>
            </div>
        </div>
    </div>
    
    <button class="print-button" style="position: fixed; top: 20px; right: 20px; padding: 10px 20px;" onclick="window.print();">In Phiếu</button>
</body>
</html>