<?php
/**
 * Created by PhpStorm.
 * User: SpeedSMS
 * Date: 9/20/15
 * Time: 5:06 PM
 */

class SpeedSMSAPI {
    const SMS_TYPE_QC = 1; // loai tin nhan quang cao
    const SMS_TYPE_CSKH = 2; // loai tin nhan cham soc khach hang
    const SMS_TYPE_BRANDNAME = 3; // loai tin nhan brand name cskh
    const SMS_TYPE_NOTIFY = 4; // sms gui bang brandname Notify
    const SMS_TYPE_GATEWAY = 5; // sms gui bang so di dong ca nhan tu app android

    private $ROOT_URL = "https://api.speedsms.vn/index.php";
    private $accessToken;

    public function __construct($api_key) {
        $this->accessToken = $api_key;
    }

    public function getUserInfo() {
        $url = $this->ROOT_URL . '/user/info';
        $headers = ['Accept: application/json'];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_USERPWD, $this->accessToken . ':x');

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            curl_close($ch);
            return ['status' => 'error', 'message' => curl_error($ch)];
        }

        curl_close($ch);
        return json_decode($result, true) ?: ['status' => 'error', 'message' => 'Không nhận được dữ liệu'];
    }

    public function sendSMS($to, $smsContent, $smsType, $sender) {
        if (!is_array($to) || empty($to) || empty($smsContent)) {
            return ['status' => 'error', 'message' => 'Danh sách số điện thoại hoặc nội dung không hợp lệ'];
        }

        $type = self::SMS_TYPE_CSKH;
        if (!empty($smsType) && in_array($smsType, [self::SMS_TYPE_QC, self::SMS_TYPE_CSKH, self::SMS_TYPE_BRANDNAME, self::SMS_TYPE_NOTIFY, self::SMS_TYPE_GATEWAY])) {
            $type = $smsType;
        }

        if (($type == self::SMS_TYPE_BRANDNAME || $type == self::SMS_TYPE_GATEWAY) && empty($sender)) {
            return ['status' => 'error', 'message' => 'Sender (brandname hoặc device ID) không được để trống'];
        }

        $json = json_encode(['to' => $to, 'content' => $smsContent, 'sms_type' => $type, 'sender' => $sender]);

        $headers = ['Content-type: application/json'];
        $url = $this->ROOT_URL . '/sms/send';

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_USERPWD, $this->accessToken . ':x');

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            $error = curl_error($ch);
            curl_close($ch);
            return ['status' => 'error', 'message' => "Lỗi cURL: $error"];
        }

        curl_close($ch);
        return json_decode($result, true) ?: ['status' => 'error', 'message' => 'Không nhận được phản hồi từ API'];
    }

    public function sendMMS($to, $smsContent, $link, $sender) {
        if (!is_array($to) || empty($to) || empty($smsContent) || empty($link)) {
            return ['status' => 'error', 'message' => 'Danh sách số điện thoại, nội dung hoặc link không hợp lệ'];
        }

        $type = self::SMS_TYPE_CSKH;
        if (!empty($smsType) && in_array($smsType, [self::SMS_TYPE_QC, self::SMS_TYPE_CSKH, self::SMS_TYPE_BRANDNAME, self::SMS_TYPE_NOTIFY, self::SMS_TYPE_GATEWAY])) {
            $type = $smsType;
        }

        if (($type == self::SMS_TYPE_BRANDNAME || $type == self::SMS_TYPE_GATEWAY) && empty($sender)) {
            return ['status' => 'error', 'message' => 'Sender (brandname hoặc device ID) không được để trống'];
        }

        $json = json_encode(['to' => $to, 'content' => $smsContent, 'link' => $link, 'sender' => $sender]);

        $headers = ['Content-type: application/json'];
        $url = $this->ROOT_URL . '/mms/send';

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_USERPWD, $this->accessToken . ':x');

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            $error = curl_error($ch);
            curl_close($ch);
            return ['status' => 'error', 'message' => "Lỗi cURL: $error"];
        }

        curl_close($ch);
        return json_decode($result, true) ?: ['status' => 'error', 'message' => 'Không nhận được phản hồi từ API'];
    }

    public function sendVoice($to, $smsContent) {
        if (empty($to) || empty($smsContent)) {
            return ['status' => 'error', 'message' => 'Số điện thoại hoặc nội dung không hợp lệ'];
        }

        $json = json_encode(['to' => $to, 'content' => $smsContent]);

        $headers = ['Content-type: application/json'];
        $url = $this->ROOT_URL . '/voice/otp';

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_USERPWD, $this->accessToken . ':x');

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            $error = curl_error($ch);
            curl_close($ch);
            return ['status' => 'error', 'message' => "Lỗi cURL: $error"];
        }

        curl_close($ch);
        return json_decode($result, true) ?: ['status' => 'error', 'message' => 'Không nhận được phản hồi từ API'];
    }
}