<?php
require_once __DIR__ . '/../../config/database.php';

if (!isset($_POST['action']) && !isset($_GET['action'])) {
    header('Location: index.php');
    exit();
}

$action = $_POST['action'] ?? $_GET['action'];

if ($action == 'create') {
    $customer_name = $_POST['customer_name'] ?? '';
    $customer_phone = $_POST['customer_phone'] ?? '';
    $appointment_datetime = $_POST['appointment_datetime'] ?? '';
    $notes = $_POST['notes'] ?? '';

    $stmt = $conn->prepare("INSERT INTO service_appointments (customer_name, customer_phone, appointment_datetime, notes) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $customer_name, $customer_phone, $appointment_datetime, $notes);
    $stmt->execute();
    
    header('Location: index.php');
    exit();
}

if ($action == 'delete') {
    $id = (int)($_GET['id'] ?? 0);
    $stmt = $conn->prepare("DELETE FROM service_appointments WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();

    header('Location: index.php');
    exit();
}