<?php
require_once __DIR__ . '/../../templates/header.php';
?>

<style>
    .nav-tabs .nav-link.active { font-weight: bold; color: #4e73df; }
    #stores-table thead th { background-color:#4e73df !important; color:#ffffff !important; font-weight:bold; vertical-align: middle; }
    #stores-table tbody tr:nth-child(even) { background-color: #f8f9fc; }
    #stores-table tbody tr:hover { background-color: #eaecf4; }
    .modal-header { background-color: #f8f9fc; border-bottom: 1px solid #e3e6f0; }
    .modal-title { font-weight: 600; color: #3a3b45; }
</style>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Thiết lập hệ thống</h1>

    <ul class="nav nav-tabs mb-4">
        <li class="nav-item"><a class="nav-link" href="/quanlybanhang/modules/users/list.php"><i class="fas fa-user fa-sm me-2"></i>Nhân viên</a></li>
        <li class="nav-item"><a class="nav-link" href="/quanlybanhang/modules/users/permissions.php"><i class="fas fa-user-shield fa-sm me-2"></i>Phân quyền</a></li>
        <li class="nav-item"><a class="nav-link" href="/quanlybanhang/modules/settings/print_config.php"><i class="fas fa-print fa-sm me-2"></i>Cài đặt trang in</a></li>
        <li class="nav-item"><a class="nav-link active" href="/quanlybanhang/modules/stores/list.php"><i class="fas fa-warehouse fa-sm me-2"></i>Quản lý kho</a></li>
    </ul>

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Danh sách kho</h6>
            <button class="btn btn-primary btn-sm" id="btn-add-store" data-bs-toggle="modal" data-bs-target="#store-modal">
                <i class="fas fa-plus fa-sm"></i> Thêm Kho
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="stores-table" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th style="width: 50px;">#</th>
                            <th>Tên Kho</th>
                            <th>Ngày tạo</th>
                            <th style="width: 100px;" class="text-center">Hành động</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="store-modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="store-form">
                <input type="hidden" name="action" value="save_store">
                <input type="hidden" name="id" id="store-id">
                <div class="modal-header">
                    <h5 class="modal-title" id="modal-title">Thêm Kho</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="store_name" class="form-label">Tên Kho</label>
                        <input type="text" class="form-control" name="store_name" id="store_name" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Bỏ qua</button>
                    <button type="submit" class="btn btn-primary">Lưu</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>

<script>
$(document).ready(function() {
    const AJAX_URL = '/quanlybanhang/ajax/stores_ajax.php';
    const storeModal = new bootstrap.Modal(document.getElementById('store-modal'));

    function loadStores() {
        $.getJSON(AJAX_URL, { action: 'get_stores' }, function(response) {
            if (response.status === 'success') {
                const tbody = $('#stores-table tbody');
                tbody.empty();
                response.data.forEach((store, index) => {
                    tbody.append(`
                        <tr>
                            <td>${index + 1}</td>
                            <td>${store.store_name}</td>
                            <td>${new Date(store.created).toLocaleString('vi-VN')}</td>
                            <td class="text-center">
                                <div class="btn-group btn-group-sm">
                                    <button class="btn btn-warning btn-edit" data-id="${store.id}" data-name="${store.store_name}"><i class="fas fa-edit"></i></button>
                                    <button class="btn btn-danger btn-delete" data-id="${store.id}"><i class="fas fa-trash"></i></button>
                                </div>
                            </td>
                        </tr>
                    `);
                });
            }
        });
    }

    $('#btn-add-store').on('click', function() {
        $('#store-form')[0].reset();
        $('#store-id').val('');
        $('#modal-title').text('Thêm Kho');
    });

    $('#stores-table').on('click', '.btn-edit', function() {
        const id = $(this).data('id');
        const name = $(this).data('name');
        $('#store-id').val(id);
        $('#store_name').val(name);
        $('#modal-title').text('Sửa Kho');
        storeModal.show();
    });

    $('#store-form').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: AJAX_URL,
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                alert(response.message);
                if (response.status === 'success') {
                    storeModal.hide();
                    loadStores();
                }
            }
        });
    });

    $('#stores-table').on('click', '.btn-delete', function() {
        const id = $(this).data('id');
        if (confirm('Bạn có chắc muốn xóa kho này? Thao tác này có thể ảnh hưởng đến các dữ liệu liên quan.')) {
            $.ajax({
                url: AJAX_URL,
                type: 'POST',
                data: { action: 'delete_store', id: id },
                dataType: 'json',
                success: function(response) {
                    alert(response.message);
                    if (response.status === 'success') {
                        loadStores();
                    }
                },
                error: function() {
                    alert('Đã xảy ra lỗi khi kết nối đến máy chủ.');
                }
            });
        }
    });

    loadStores();
});
</script>