<?php
// Phiên bản tương tác của update_password.php
require_once __DIR__ . '/core/init.php';

$username_to_update = 'phuongbang';
$message = '';
$is_success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_password = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    if (empty($new_password)) {
        $message = "<p style='color: red;'>Lỗi: Mật khẩu không được để trống.</p>";
    } elseif ($new_password !== $confirm_password) {
        $message = "<p style='color: red;'>Lỗi: Mật khẩu xác nhận không khớp.</p>";
    } else {
        // Mọi kiểm tra đã qua, tiến hành cập nhật
        if (!isset($conn) || $conn->connect_error) {
             $message = "<p style='color: red;'>Lỗi: Không thể kết nối database.</p>";
        } else {
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE cms_users SET password = ?, salt = '' WHERE username = ?");
            if ($stmt) {
                $stmt->bind_param("ss", $hashed_password, $username_to_update);
                if ($stmt->execute()) {
                    $message = "<h3 style='color: green;'>THÀNH CÔNG!</h3>";
                    $message .= "<p>Đã cập nhật mật khẩu cho tài khoản: <b>" . htmlspecialchars($username_to_update) . "</b></p>";
                    $message .= "<p>Mật khẩu mới của bạn là: <b>" . htmlspecialchars($new_password) . "</b></p>";
                    $message .= "<p style='color:blue;'>Bây giờ bạn có thể quay lại trang đăng nhập và sử dụng mật khẩu này.</p>";
                    $message .= "<p style='color:red;'><b>QUAN TRỌNG:</b> Hãy xóa file 'update_password.php' này ngay bây giờ vì lý do bảo mật!</p>";
                    $is_success = true;
                } else {
                    $message = "<p style='color: red;'>Lỗi khi thực thi câu lệnh: " . htmlspecialchars($stmt->error) . "</p>";
                }
                $stmt->close();
            } else {
                $message = "<p style='color: red;'>Lỗi khi chuẩn bị câu lệnh: " . htmlspecialchars($conn->error) . "</p>";
            }
            $conn->close();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <title>Cập nhật mật khẩu</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
        .container { background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); text-align: center; width: 400px; }
        input[type="password"] { width: calc(100% - 22px); padding: 10px; margin-bottom: 15px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px; }
        button { background-color: #007bff; color: white; padding: 12px 20px; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; width: 100%; }
        button:hover { background-color: #0056b3; }
        label { display: block; margin-bottom: 5px; text-align: left; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Thiết lập mật khẩu mới</h2>
        <p>Cho tài khoản: <b><?php echo htmlspecialchars($username_to_update); ?></b></p>
        <hr>
        <?php if (!empty($message)) { echo $message; } ?>
        <?php if (!$is_success): ?>
        <form method="POST" action="update_password.php">
            <div>
                <label for="new_password">Nhập mật khẩu mới:</label>
                <input type="password" id="new_password" name="new_password" required>
            </div>
            <div>
                <label for="confirm_password">Xác nhận mật khẩu mới:</label>
                <input type="password" id="confirm_password" name="confirm_password" required>
            </div>
            <button type="submit">Cập nhật mật khẩu</button>
        </form>
        <?php endif; ?>
    </div>
</body>
</html>