<?php
// Thiết lập để hiển thị tất cả các lỗi PHP, rất quan trọng cho việc chẩn đoán
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Dùng header này để trình duyệt hiển thị kết quả dạng văn bản thuần, dễ đọc
header('Content-Type: text/plain; charset=utf-8');

echo "--- BẮT ĐẦU CHẨN ĐOÁN ---\n\n";

// Nạp file khởi tạo để có kết nối database
require_once __DIR__ . '/../core/init.php';

// --- KIỂM TRA 1: KẾT NỐI DATABASE ---
echo "1. Kiểm tra biến kết nối (\$conn):\n";
if (isset($conn) && $conn instanceof mysqli) {
    echo "   -> OK! Biến \$conn tồn tại và là một đối tượng mysqli.\n";
    if ($conn->connect_error) {
        echo "   -> LỖI KẾT NỐI: " . $conn->connect_error . "\n";
    } else {
        echo "   -> OK! Kết nối đến database thành công.\n";
    }
} else {
    echo "   -> LỖI NGHIÊM TRỌNG: Biến \$conn không tồn tại hoặc không hợp lệ. Vui lòng kiểm tra file init.php.\n";
    exit(); // Dừng lại ở đây nếu không có kết nối
}
echo "\n";


// --- KIỂM TRA 2: CHẠY TRUY VẤN SQL ---
echo "2. Thực thi câu lệnh SQL để lấy doanh thu hôm nay:\n";

// Đây là câu lệnh SQL quan trọng nhất
$sql = "SELECT COUNT(ID) as order_count, SUM(total_money) as total_revenue FROM cms_orders WHERE deleted = 0 AND DATE(sell_date) = CURDATE()";

echo "   Câu lệnh SQL sẽ chạy: " . $sql . "\n";

$result = $conn->query($sql);

if ($result) {
    echo "   -> OK! Truy vấn đã chạy thành công.\n";
    $data = $result->fetch_assoc();
    
    echo "\n3. Phân tích kết quả trả về:\n";
    echo "   Số dòng dữ liệu trả về: " . $result->num_rows . "\n";
    echo "   Nội dung dữ liệu (dùng var_dump):\n";
    var_dump($data);
    
} else {
    echo "   -> LỖI KHI CHẠY TRUY VẤN!\n";
    echo "   Thông báo lỗi từ MySQL: " . $conn->error . "\n";
}

$conn->close();

echo "\n--- KẾT THÚC CHẨN ĐOÁN ---";

?>