<?php
require_once __DIR__ . '/../config/database.php';
header('Content-Type: application/json; charset=utf-8');

try {
    $sql = "SELECT * FROM cms_payment_display WHERE id = 1";
    $result = $conn->query($sql);
    
    if ($result && $row = $result->fetch_assoc()) {
        echo json_encode([
            'status' => 'success',
            'payment_status' => $row['payment_status'],
            'order_id' => intval($row['order_id']),
            'order_code' => $row['order_code'],
            'customer_name' => $row['customer_name'],
            'customer_phone' => $row['customer_phone'],
            'total_amount' => floatval($row['total_amount'])
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No display data found']);
    }
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>