<?php
// /ajax/groups_ajax.php (Phiên bản nâng cấp)
require_once __DIR__ . '/../core/init.php';

header('Content-Type: application/json');
$response = ['status' => 'error', 'message' => 'Hành động không hợp lệ.'];

// --- THÊM NHÓM MỚI ---
if (isset($_POST['action']) && $_POST['action'] == 'add_group') {
    // ... code thêm nhóm giữ nguyên như cũ ...
}

// --- LẤY QUYỀN CỦA MỘT NHÓM ---
if (isset($_GET['action']) && $_GET['action'] == 'get_permissions') {
    if (isset($_GET['group_id'])) {
        $group_id = intval($_GET['group_id']);
        $stmt = $conn->prepare("SELECT group_permission FROM cms_users_group WHERE id = ?");
        $stmt->bind_param("i", $group_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $row = $result->fetch_assoc();
        
        if ($row && !empty($row['group_permission'])) {
            // Giải mã chuỗi JSON từ CSDL thành mảng PHP
            $permissions = json_decode($row['group_permission'], true);
            $response = ['status' => 'success', 'permissions' => $permissions];
        } else {
            // Nếu chưa có quyền nào, trả về mảng rỗng
            $response = ['status' => 'success', 'permissions' => []];
        }
        $stmt->close();
    }
}

// --- LƯU QUYỀN CHO MỘT NHÓM ---
if (isset($_POST['action']) && $_POST['action'] == 'save_permissions') {
    if (isset($_POST['group_id']) && isset($_POST['permissions'])) {
        $group_id = intval($_POST['group_id']);
        // Mã hóa mảng quyền thành chuỗi JSON để lưu vào CSDL
        $permissions_json = json_encode($_POST['permissions']);

        $stmt = $conn->prepare("UPDATE cms_users_group SET group_permission = ? WHERE id = ?");
        $stmt->bind_param("si", $permissions_json, $group_id);

        if ($stmt->execute()) {
            $response = ['status' => 'success', 'message' => 'Cập nhật quyền thành công!'];
        } else {
            $response['message'] = 'Lỗi khi cập nhật quyền.';
        }
        $stmt->close();
    } else {
        $response['message'] = 'Dữ liệu không đầy đủ.';
    }
}


echo json_encode($response);
$conn->close();
?>