<?php
require_once __DIR__ . '/../core/init.php';
header('Content-Type: application/json; charset=utf-8');

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$response = ['status' => 'error', 'message' => 'Có lỗi không xác định.'];

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    $response['message'] = 'Yêu cầu không hợp lệ.';
    echo json_encode($response);
    exit();
}

$userId = $_SESSION['user_id'] ?? 0;
if ($userId === 0) {
    http_response_code(401);
    $response['message'] = 'Phiên làm việc đã hết hạn. Vui lòng đăng nhập lại.';
    echo json_encode($response);
    exit();
}

$customer_name = trim($_POST['customer_name'] ?? '');
$customer_phone = trim($_POST['customer_phone'] ?? '');
$customer_address = trim($_POST['customer_address'] ?? '');

if (empty($customer_name)) {
    http_response_code(400);
    $response['message'] = 'Tên khách hàng là bắt buộc.';
    echo json_encode($response);
    exit();
}

try {
    $sql = "INSERT INTO cms_customers (customer_name, customer_phone, customer_addr, user_init) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        throw new Exception('Lỗi khi chuẩn bị câu lệnh SQL: ' . $conn->error);
    }
    
    $stmt->bind_param('sssi', $customer_name, $customer_phone, $customer_address, $userId);
    
    if ($stmt->execute()) {
        $new_customer_id = $conn->insert_id;
        $response = [
            'status' => 'success',
            'message' => 'Thêm khách hàng thành công!',
            'newCustomer' => [
                'id' => $new_customer_id,
                'label' => $customer_name . (!empty($customer_phone) ? ' - ' . $customer_phone : '')
            ]
        ];
    } else {
        throw new Exception('Lỗi khi thực thi lệnh thêm khách hàng: ' . $stmt->error);
    }
    $stmt->close();
} catch (Exception $e) {
    http_response_code(500);
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
?>