<?php
require_once __DIR__ . '/../core/init.php';

header('Content-Type: application/json; charset=utf-8');
$response = ['status' => 'error', 'message' => 'Hành động không hợp lệ.'];
$conn->begin_transaction(); 

try {
    if (isset($_POST['action']) && $_POST['action'] == 'add_user') {
        if (empty($_POST['username']) || empty($_POST['password']) || empty($_POST['email']) || empty($_POST['display_name']) || !isset($_POST['group_id']) || !isset($_POST['store_id'])) {
            $response['message'] = 'Vui lòng điền đầy đủ các trường bắt buộc.';
        } else {
            $username = trim($_POST['username']);
            $email = trim($_POST['email']);
            $password = $_POST['password'];
            $store_id = intval($_POST['store_id']);
            $display_name = trim($_POST['display_name']);
            $group_id = intval($_POST['group_id']);
            $commission = floatval($_POST['commission'] ?? 0);

            $stmt_check = $conn->prepare("SELECT id FROM cms_users WHERE username = ? OR email = ?");
            $stmt_check->bind_param("ss", $username, $email);
            $stmt_check->execute();
            if ($stmt_check->get_result()->fetch_assoc()) {
                $response['message'] = 'Mã nhân viên hoặc Email đã tồn tại trong hệ thống. Vui lòng kiểm tra lại.';
            } else {
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                
                // SỬ DỤNG CÂU LỆNH INSERT GỐC - không chỉ định cột ID
                $sql = "INSERT INTO cms_users (username, password, email, display_name, user_status, group_id, commission, store_id, created, updated) VALUES (?, ?, ?, ?, 1, ?, ?, ?, NOW(), NOW())";
                
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("ssssidi", $username, $hashed_password, $email, $display_name, $group_id, $commission, $store_id);
                
                if ($stmt->execute()) {
                    $response = ['status' => 'success', 'message' => 'Thêm nhân viên mới thành công!'];
                } else {
                    $response['message'] = 'Lỗi khi thêm vào CSDL: ' . $stmt->error;
                }
                $stmt->close();
            }
            $stmt_check->close();
        }
    } 
    // ... Các action khác (delete, edit, get_details) giữ nguyên như cũ ...
    else if (isset($_POST['action']) && $_POST['action'] == 'delete_user') {
        $user_id = intval($_POST['user_id'] ?? 0);
        if ($user_id == 1) { $response['message'] = 'Không thể xóa tài khoản Quản trị viên cao nhất!'; } 
        else if ($user_id > 0) {
            $stmt = $conn->prepare("DELETE FROM cms_users WHERE id = ?");
            $stmt->bind_param("i", $user_id);
            if ($stmt->execute()) { $response = ['status' => 'success', 'message' => 'Xóa nhân viên thành công!']; } 
            else { $response['message'] = 'Lỗi khi xóa dữ liệu.'; }
            $stmt->close();
        } else { $response['message'] = 'Thiếu ID nhân viên.'; }
    } else if (isset($_GET['action']) && $_GET['action'] == 'get_user_details') {
        $user_id = intval($_GET['user_id'] ?? 0);
        $stmt = $conn->prepare("SELECT id, username, display_name, email, group_id, store_id, commission FROM cms_users WHERE id = ?");
        $stmt->bind_param("i", $user_id); 
        $stmt->execute(); 
        $data = $stmt->get_result()->fetch_assoc();
        if ($data) { $response = ['status' => 'success', 'data' => $data]; } 
        else { $response['message'] = 'Không tìm thấy nhân viên.'; }
        $stmt->close();
    } else if (isset($_POST['action']) && $_POST['action'] == 'edit_user') {
        $user_id = intval($_POST['user_id'] ?? 0);
        $store_id = intval($_POST['store_id'] ?? 0);
        $username = trim($_POST['username']);
        $email = trim($_POST['email']);
        $display_name = trim($_POST['display_name']);
        $group_id = intval($_POST['group_id']);
        $password = $_POST['password'];
        $commission = floatval($_POST['commission'] ?? 0);

        if (empty($user_id) || empty($username) || empty($email) || empty($display_name)) {
            $response['message'] = 'Vui lòng điền đầy đủ thông tin.';
        } else {
            $stmt_check = $conn->prepare("SELECT id FROM cms_users WHERE (username = ? OR email = ?) AND id != ?");
            $stmt_check->bind_param("ssi", $username, $email, $user_id);
            $stmt_check->execute();
            if ($stmt_check->get_result()->fetch_assoc()) {
                 $response['message'] = 'Mã nhân viên hoặc Email đã tồn tại ở một tài khoản khác.';
            } else {
                if (!empty($password)) {
                    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                    $stmt = $conn->prepare("UPDATE cms_users SET username=?, password=?, email=?, display_name=?, group_id=?, store_id=?, commission=? WHERE id=?");
                    $stmt->bind_param("ssssiidi", $username, $hashed_password, $email, $display_name, $group_id, $store_id, $commission, $user_id);
                } else {
                    $stmt = $conn->prepare("UPDATE cms_users SET username=?, email=?, display_name=?, group_id=?, store_id=?, commission=? WHERE id=?");
                    $stmt->bind_param("sssiidi", $username, $email, $display_name, $group_id, $store_id, $commission, $user_id);
                }
                if ($stmt->execute()) { $response = ['status' => 'success', 'message' => 'Cập nhật thành công!']; } 
                else { $response['message'] = 'Lỗi khi cập nhật: ' . $stmt->error; }
                $stmt->close();
            }
            $stmt_check->close();
        }
    }
    
    $conn->commit();
} catch (Exception $e) {
    $conn->rollback();
    $response['message'] = 'Đã xảy ra lỗi: ' . $e->getMessage();
}

echo json_encode($response);
$conn->close();
?>