<?php
// Thay thế bằng file init của bạn để có kết nối $conn
require_once __DIR__ . '/../../../../core/init.php'; 
require_once __DIR__ . '/../includes/ZaloService.php';

header('Content-Type: application/json; charset=utf-8');
if (session_status() == PHP_SESSION_NONE) { session_start(); }

$action = $_REQUEST['action'] ?? '';
$response = ['status' => 'error', 'message' => 'Invalid action.'];

// TODO: Lấy Zalo Access Token từ CSDL hoặc file cấu hình của bạn
$zaloAccessToken = 'YOUR_ZALO_ACCESS_TOKEN';

switch ($action) {
    case 'get_templates':
        $stmt = $conn->prepare("SELECT id, template_id, template_name, parameters FROM zns_templates ORDER BY template_name ASC");
        $stmt->execute();
        $result = $stmt->get_result();
        $templates = $result->fetch_all(MYSQLI_ASSOC);
        $response = ['status' => 'success', 'data' => $templates];
        break;

    case 'send_campaign':
        // Giả lập logic lấy danh sách khách hàng
        // TODO: Viết logic thực tế để lấy SĐT khách hàng từ nhóm hoặc cá nhân đã chọn
        $recipients = [
            ['id' => 1, 'phone' => '090xxxxxxx'],
            ['id' => 2, 'phone' => '091xxxxxxx'],
        ];

        $campaignName = $_POST['campaign_name'] ?? 'Untitled Campaign';
        $templateId = $_POST['template_id'] ?? null;
        $znsTemplateDbId = $_POST['zns_template_db_id'] ?? null;
        $params = $_POST['params'] ?? [];
        
        if (empty($templateId) || empty($znsTemplateDbId)) {
            $response = ['status' => 'error', 'message' => 'Template ID is missing.'];
            break;
        }

        // 1. Tạo chiến dịch
        $stmt = $conn->prepare("INSERT INTO zns_campaigns (campaign_name, zns_template_id, total_recipients) VALUES (?, ?, ?)");
        $totalRecipients = count($recipients);
        $stmt->bind_param('sii', $campaignName, $znsTemplateDbId, $totalRecipients);
        $stmt->execute();
        $campaignId = $stmt->insert_id;

        // 2. Gửi tin nhắn
        $zaloService = new ZaloService($zaloAccessToken);
        foreach ($recipients as $recipient) {
            // TODO: Thay thế các biến placeholder như {ten_khach_hang} bằng dữ liệu thực
            $finalParams = [];
            foreach ($params as $key => $value) {
                // Ví dụ đơn giản, bạn cần logic phức tạp hơn
                if($value === '{ten_khach_hang}') {
                    // $customerName = ... // Lấy tên KH từ CSDL
                    // $finalParams[$key] = $customerName;
                } else {
                    $finalParams[$key] = $value;
                }
            }

            $result = $zaloService->sendZNS($recipient['phone'], $templateId, $finalParams);

            // 3. Ghi log
            $logStmt = $conn->prepare("INSERT INTO zns_logs (campaign_id, customer_id, customer_phone, zalo_message_id, status, error_code, error_message) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $msgId = $result['data']['msg_id'] ?? null;
            $status = $result['status'] === 'success' ? 'sent' : 'failed';
            $errorCode = $result['error_code'] ?? null;
            $errorMsg = $result['message'] ?? null;
            $logStmt->bind_param('iisssss', $campaignId, $recipient['id'], $recipient['phone'], $msgId, $status, $errorCode, $errorMsg);
            $logStmt->execute();
        }
        
        // 4. Cập nhật trạng thái chiến dịch
        $conn->query("UPDATE zns_campaigns SET status = 'completed' WHERE id = $campaignId");
        $response = ['status' => 'success', 'message' => 'Chiến dịch đã được gửi thành công!'];
        break;
}

echo json_encode($response);