// /assets/js/permissions.js (Phiên bản nâng cấp)
$(document).ready(function() {
    
    // --- HÀM LẤY QUYỀN KHI CHỌN NHÓM ---
    function getPermissionsForGroup(groupId) {
        $.ajax({
            url: '/quanlybanhang/ajax/groups_ajax.php',
            type: 'GET',
            dataType: 'json',
            data: {
                action: 'get_permissions',
                group_id: groupId
            },
            success: function(response) {
                // Bỏ check tất cả các checkbox trước khi cập nhật
                $('.permission-check').prop('checked', false);
                
                if (response.status === 'success' && response.permissions) {
                    // Lặp qua các quyền của nhóm và check vào các checkbox tương ứng
                    response.permissions.forEach(function(permissionKey) {
                        $('.permission-check[value="' + permissionKey + '"]').prop('checked', true);
                    });
                }
                checkSelectAllState();
            }
        });
    }

    // --- SỰ KIỆN KHI CLICK VÀO RADIO BUTTON CỦA NHÓM ---
    $('.group-radio').on('change', function() {
        var selectedGroupId = $(this).val();
        getPermissionsForGroup(selectedGroupId);
    });

    // --- SỰ KIỆN LƯU QUYỀN ---
    $('#savePermissionsBtn').on('click', function() {
        var selectedGroupId = $('.group-radio:checked').val();
        var selectedPermissions = [];
        // Lấy tất cả các checkbox quyền đã được chọn
        $('.permission-check:checked').each(function() {
            selectedPermissions.push($(this).val());
        });

        $.ajax({
            url: '/quanlybanhang/ajax/groups_ajax.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'save_permissions',
                group_id: selectedGroupId,
                permissions: selectedPermissions
            },
            success: function(response) {
                alert(response.message);
            },
            error: function() {
                alert('Có lỗi xảy ra khi lưu quyền.');
            }
        });
    });

    // --- LOGIC CHO NÚT "CHỌN TẤT CẢ" ---
    $('#checkAll').on('click', function() {
        $('.permission-check').prop('checked', $(this).prop('checked'));
    });
    
    // Kiểm tra trạng thái của "Check All" khi click vào từng checkbox
    $('.permission-check').on('click', function() {
        checkSelectAllState();
    });

    function checkSelectAllState() {
        if ($('.permission-check:checked').length == $('.permission-check').length) {
            $('#checkAll').prop('checked', true);
        } else {
            $('#checkAll').prop('checked', false);
        }
    }


    // --- KÍCH HOẠT LẤY QUYỀN CHO NHÓM ĐƯỢC CHỌN MẶC ĐỊNH KHI TẢI TRANG ---
    var initialGroupId = $('.group-radio:checked').val();
    if (initialGroupId) {
        getPermissionsForGroup(initialGroupId);
    }


    // --- LOGIC THÊM NHÓM MỚI (giữ nguyên) ---
    $('#saveGroupBtn').on('click', function() {
        // ... code thêm nhóm mới giữ nguyên như cũ ...
    });
});