<?php
// Nhúng file khởi tạo để có kết nối CSDL ($conn)
require_once __DIR__ . '/core/init.php';

// --- THAY ĐỔI ID SẢN PHẨM BẠN MUỐN KIỂM TRA TẠI ĐÂY ---
$product_id_to_check = 1036;
// ----------------------------------------------------

// CSS để hiển thị bảng cho đẹp
echo "<style> body { font-family: sans-serif; } table { border-collapse: collapse; width: 80%; margin: 20px auto; font-size: 14px; } th, td { border: 1px solid #ddd; padding: 8px; text-align: left; } th { background-color: #f2f2f2; } .summary { border: 2px solid #007bff; padding: 15px; margin: 20px auto; width: 78%; background-color: #f8f9fa; } .summary h3 { margin-top: 0; } .summary p { margin: 5px 0; font-size: 16px; } .summary span { font-weight: bold; color: #dc3545; } </style>";
echo "<h1>Lịch sử nhập hàng cho sản phẩm ID: " . htmlspecialchars($product_id_to_check) . "</h1>";

$history = [];
$product_name = '';

// Các biến để tính tổng LÝ THUYẾT
$total_quantity_correct = 0;
$total_value_correct = 0;

$stmt = $conn->prepare("SELECT i.input_date, i.input_code, i.detail_input, p.prd_name FROM cms_input i LEFT JOIN cms_products p ON p.id = ? WHERE i.deleted = 0 ORDER BY i.input_date DESC");
$stmt->bind_param("i", $product_id_to_check);
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    if (empty($product_name) && !empty($row['prd_name'])) {
        $product_name = $row['prd_name'];
    }
    if (empty($row['detail_input'])) continue;
    
    $products_in_slip = json_decode($row['detail_input'], true);
    if (is_array($products_in_slip)) {
        foreach ($products_in_slip as $item) {
            if (isset($item['id']) && $item['id'] == $product_id_to_check) {
                $quantity = $item['quantity'] ?? 0;
                $price = $item['price'] ?? 0;
                $total = $quantity * $price;

                $history[] = [
                    'date' => $row['input_date'],
                    'code' => $row['input_code'],
                    'quantity' => $quantity,
                    'price' => $price,
                    'total' => $total
                ];

                // Cộng dồn vào tổng LÝ THUYẾT
                $total_quantity_correct += $quantity;
                $total_value_correct += $total;
                
                break;
            }
        }
    }
}
$stmt->close();

if (!empty($product_name)) {
    echo "<h2>Tên sản phẩm: " . htmlspecialchars($product_name) . "</h2>";
}

if (empty($history)) {
    echo "<p>Không tìm thấy lịch sử nhập hàng cho sản phẩm này.</p>";
} else {
    // Hiển thị bảng lịch sử
    echo "<table><thead><tr><th>Ngày Nhập</th><th>Mã Phiếu</th><th>Số Lượng</th><th>Đơn Giá Nhập</th><th>Thành Tiền</th></tr></thead><tbody>";
    foreach ($history as $entry) {
        echo "<tr><td>" . htmlspecialchars($entry['date']) . "</td><td>" . htmlspecialchars($entry['code']) . "</td><td>" . number_format($entry['quantity']) . "</td><td style='color:red; font-weight:bold;'>" . number_format($entry['price'], 2) . "</td><td>" . number_format($entry['total'], 2) . "</td></tr>";
    }
    echo "</tbody></table>";
    
    // Hiển thị bảng TỔNG KẾT LÝ THUYẾT
    echo "<div class='summary'>";
    echo "<h3>KẾT QUẢ TÍNH TOÁN KHO 'LÝ THUYẾT' (Dựa trên lịch sử nhập)</h3>";
    echo "<p>Tổng Số Lượng Đáng Lẽ Phải Có: <span>" . number_format($total_quantity_correct) . "</span></p>";
    echo "<p>Tổng Giá Trị Kho Đáng Lẽ Phải Có: <span>" . number_format($total_value_correct, 2) . "</span></p>";
    if ($total_quantity_correct > 0) {
        $avg_cost_correct = $total_value_correct / $total_quantity_correct;
        echo "<p>=> Giá Vốn Bình Quân 'ĐÚNG': <span>" . number_format($avg_cost_correct, 2) . "</span></p>";
    }
    echo "</div>";
}
?>