<?php
// Tệp: core/helpers.php

if (!function_exists('has_permission')) {
    function has_permission($permission_key) {
        // Lấy danh sách quyền từ SESSION, nếu không có thì trả về mảng rỗng
        $user_permissions = $_SESSION['user_permissions'] ?? [];

        // Kiểm tra xem quyền có tồn tại trong danh sách không
        return in_array($permission_key, $user_permissions);
    }
}


/**
 * Hàm kiểm tra xem người dùng có đang truy cập bằng thiết bị di động hay không.
 * @return bool True nếu là di động, False nếu là desktop.
 */
function is_mobile() {
    if (empty($_SERVER['HTTP_USER_AGENT'])) {
        return false;
    }
    
    // Danh sách các từ khóa phổ biến trong User Agent của di động
    $agents = [
        'Android', 'iPhone', 'iPad', 'iPod', 'BlackBerry', 'Mobile',
        'webOS', 'Windows Phone', 'Opera Mini'
    ];
    
    foreach ($agents as $agent) {
        if (stripos($_SERVER['HTTP_USER_AGENT'], $agent) !== false) {
            return true;
        }
    }
    return false;
}
?>