<?php
session_start();
require_once __DIR__ . '/core/init.php'; 
require_once __DIR__ . '/core/helpers.php'; 

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$page = $_GET['page'] ?? 'dashboard';

$allowed_pages = ['dashboard', 'orders', 'products', 'notifications', 'more', 'customers', 'suppliers', 'profit'];
if (!in_array($page, $allowed_pages)) {
    $page = 'dashboard';
}

$page_title = 'Tổng quan';
if ($page == 'orders') $page_title = 'Đơn hàng';
if ($page == 'products') $page_title = 'Hàng hóa';
if ($page == 'notifications') $page_title = 'Thông báo';
if ($page == 'more') $page_title = 'Nhiều hơn';
if ($page == 'customers') $page_title = 'Khách hàng';
if ($page == 'suppliers') $page_title = 'Nhà cung cấp';
if ($page == 'profit') $page_title = 'Lợi nhuận';

?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    
    <title><?php echo $page_title; ?> - POS Mobile</title>
    
    <link rel="stylesheet" href="/quanlybanhang/assets/css/mobile.css?v=<?php echo time(); ?>">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>

    <div class="app-shell">
        
        <header class="app-header">
            <h1><?php echo $page_title; ?></h1>
            <div class="header-actions">
                <span style="font-size: 14px; margin-right: 10px;"><?php echo htmlspecialchars($_SESSION['display_name']); ?></span>
                <a href="mobile.php?page=more"><i class="fa-solid fa-bell"></i></a>
            </div>
        </header>

        <main class="app-content">
            <?php
                $user_id = $_SESSION['user_id'];
                $group_id = $_SESSION['group_id'];
                $store_id = $_SESSION['store_id'];
                $user_permissions = $_SESSION['user_permissions'];
            
                $view_file = "mobile_views/{$page}.php";
                if (file_exists($view_file)) {
                    include $view_file;
                } else {
                    echo "<p style='padding: 20px;'>Lỗi: Không tìm thấy file view '{$view_file}'</p>";
                }
            ?>
        </main>

        <nav class="app-bottom-nav">
            <a href="mobile.php?page=dashboard" class="<?php echo ($page == 'dashboard') ? 'active' : ''; ?>">
                <i class="fa-solid fa-chart-pie"></i>
                <span>Tổng quan</span>
            </a>
            <a href="mobile.php?page=orders" class="<?php echo ($page == 'orders') ? 'active' : ''; ?>">
                <i class="fa-solid fa-receipt"></i>
                <span>Đơn hàng</span>
            </a>
            <a href="mobile.php?page=products" class="<?php echo ($page == 'products') ? 'active' : ''; ?>">
                <i class="fa-solid fa-box"></i>
                <span>Hàng hóa</span>
            </a>
            <a href="mobile.php?page=notifications" class="<?php echo ($page == 'notifications') ? 'active' : ''; ?>">
                <i class="fa-solid fa-bell"></i>
                <span>Thông báo</span>
            </a>
            <a href="mobile.php?page=more" class="<?php echo (in_array($page, ['more', 'customers', 'suppliers', 'profit'])) ? 'active' : ''; ?>">
                <i class="fa-solid fa-bars"></i>
                <span>Nhiều hơn</span>
            </a>
        </nav>

    </div> 

</body>
</html>