<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../core/init.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['action'])) {
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'Yêu cầu không hợp lệ.']);
    exit;
}

$action = $_POST['action'];

if ($action == 'get_orders_for_consolidation') {
    $user_id = (int)$_POST['user_id'];
    $order_date_original = $_POST['order_date_original'];
    $customer_name_search = $_POST['customer_name'] ?? '';

    $params = [];
    $types = "";
    $where_conditions = ["o.user_init = ?", "DATE(o.sell_date) = ?", "o.deleted = 0"];
    $params[] = $user_id;
    $types .= "i";
    $params[] = $order_date_original;
    $types .= "s";

    if (!empty($customer_name_search)) {
        $where_conditions[] = "c.customer_name LIKE ?";
        $params[] = "%{$customer_name_search}%";
        $types .= "s";
    }
    
    $where_sql = " WHERE " . implode(" AND ", $where_conditions);
    $sql = "
        SELECT o.ID, o.output_code, o.total_money, o.consolidated_code, 
               COALESCE(c.customer_name, 'Khách lẻ') AS customer_name
        FROM cms_orders AS o
        LEFT JOIN cms_customers AS c ON o.customer_id = c.id
        {$where_sql}
        ORDER BY o.ID ASC
    ";
    
    $stmt = $conn->prepare($sql);
    if ($types) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    
    $orders_data = [];
    while ($row = $result->fetch_assoc()) {
        $orders_data[] = $row;
    }

    if (!empty($orders_data)) {
        echo '<div class="card shadow mb-4 mt-4">';
        echo '  <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-success">Danh sách đơn hàng tìm thấy (' . count($orders_data) . ' đơn)</h6></div>';
        echo '  <div class="card-body">';
        echo '<div class="table-responsive"><table class="table table-bordered table-hover" id="orders-list-table">';
        echo '<thead><tr>';
        echo '<th style="width: 30px;"><input type="checkbox" id="checkAllOrders"></th>';
        echo '<th>STT</th><th>Mã Đơn Hàng</th><th>Khách Hàng</th><th class="text-right">Tổng Tiền</th><th class="text-center">Trạng thái</th></tr></thead><tbody>';
        
        $stt = 1;
        $unprocessed_count = 0;
        $processed_codes = [];
        foreach ($orders_data as $row) {
            $is_processed = !empty($row['consolidated_code']);
            if ($is_processed) {
                $processed_codes[] = $row['consolidated_code'];
            } else {
                $unprocessed_count++;
            }
            $row_class = $is_processed ? 'processed-row' : '';
            $checkbox_disabled = $is_processed ? 'disabled' : '';
            $status_badge_class = $is_processed ? 'badge-secondary' : 'badge-success';
            $status_badge_text = $is_processed ? 'Đã xử lý' : 'Sẵn sàng';

            echo '<tr class="' . $row_class . '">';
            echo '<td><input type="checkbox" name="selected_orders[]" value="' . $row['ID'] . '" ' . $checkbox_disabled . '></td>';
            echo '<td>' . $stt++ . '</td>';
            echo '<td>' . htmlspecialchars($row['output_code']) . '</td>';
            echo '<td>' . htmlspecialchars($row['customer_name']) . '</td>';
            echo '<td class="text-right">' . number_format($row['total_money']) . '</td>';
            echo '<td class="text-center"><span class="badge ' . $status_badge_class . '">' . $status_badge_text . '</span></td>';
            echo '</tr>';
        }
        echo '</tbody></table></div></div></div>';
        
        if ($unprocessed_count > 0) {
            echo '<div class="card shadow mb-4 mt-4">';
            echo '  <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-primary">Bước 2: Cập nhật ngày giờ giao hàng mới cho các đơn đã chọn</h6></div>';
            echo '  <div class="card-body"><div class="row">';
            echo '      <div class="col-md-4"><label for="new_delivery_date">Chọn ngày giao hàng mới:</label><input type="date" id="new_delivery_date" class="form-control" value="' . date('Y-m-d') . '"></div>';
            echo '      <div class="col-md-3"><label for="new_delivery_time">Chọn giờ giao hàng mới:</label><input type="time" id="new_delivery_time" class="form-control" value="' . date('H:i') . '"></div>';
            echo '      <div class="col-md-5 d-flex align-items-end"><button type="button" id="processBtn" class="btn btn-success btn-block"><i class="fas fa-check-circle mr-1"></i> Cập nhật và In phiếu tổng hợp</button></div>';
            echo '  </div></div></div>';
        }

        $unique_codes = array_unique($processed_codes);
        if (!empty($unique_codes)) {
            echo '<div class="card shadow mb-4 mt-4">';
            echo '  <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-info"><i class="fas fa-history mr-1"></i>In lại các phiếu đã gộp</h6></div>';
            echo '  <div class="card-body">';
            echo '      <p>Các đơn hàng trong ngày này đã được gộp vào các phiếu sau. Nhấn để in lại:</p>';
            foreach ($unique_codes as $code) {
                $print_url = '/quanlybanhang/modules/consolidate_orders/print_consolidated.php?code=' . urlencode($code);
                echo '<a href="' . $print_url . '" target="_blank" class="btn btn-outline-primary mb-2 mr-2">';
                echo '  <i class="fas fa-print mr-1"></i> In lại phiếu ' . htmlspecialchars($code);
                echo '</a> ';
            }
            echo '  </div>';
            echo '</div>';
        }

    } else {
        echo '<div class="alert alert-warning mt-4">Không tìm thấy đơn hàng nào.</div>';
    }
    $stmt->close();
    exit;
}


if ($action == 'update_and_consolidate') {
    header('Content-Type: application/json');
    $selected_order_ids = $_POST['selected_order_ids'] ?? [];
    $new_order_date = $_POST['new_order_date'] ?? '';
    $new_order_time = $_POST['new_order_time'] ?? '';

    if (empty($selected_order_ids) || empty($new_order_date) || empty($new_order_time)) {
        echo json_encode(['status' => 'error', 'message' => 'Vui lòng chọn đơn hàng, ngày và giờ mới.']);
        exit;
    }
    
    $order_ids_clean = array_map('intval', $selected_order_ids);
    $order_ids_clean = array_filter($order_ids_clean, function($id) { return $id > 0; });

    if (empty($order_ids_clean)) {
        echo json_encode(['status' => 'error', 'message' => 'Không có đơn hàng hợp lệ nào được chọn.']);
        exit;
    }

    $new_order_datetime = $new_order_date . ' ' . $new_order_time;
    $consolidated_code = 'PHTH-' . date('YmdHis') . '-' . rand(100, 999);

    $conn->begin_transaction();
    try {
        $placeholders = implode(',', array_fill(0, count($order_ids_clean), '?'));
        $sql_update = "UPDATE cms_orders SET `sell_date` = ?, `consolidated_code` = ?, `order_status` = ?, `user_upd` = ?, `updated` = NOW() WHERE `ID` IN ({$placeholders}) AND `deleted` = 0 AND `consolidated_code` IS NULL";
        
        $stmt_update = $conn->prepare($sql_update);
        if ($stmt_update === false) { throw new Exception("Lỗi khi chuẩn bị câu lệnh: " . htmlspecialchars($conn->error)); }

        $order_status_val = 3;
        $user_upd_val = $_SESSION['user_id'] ?? 0;
        $bind_params = [$new_order_datetime, $consolidated_code, $order_status_val, $user_upd_val];
        $bind_types = "ssii";
        
        foreach ($order_ids_clean as $id) {
            $bind_params[] = $id;
            $bind_types .= "i";
        }

        $stmt_update->bind_param($bind_types, ...$bind_params);
        $stmt_update->execute();
        $affected_rows = $stmt_update->affected_rows;

        if ($affected_rows == 0) { throw new Exception("Không có đơn hàng nào được cập nhật hoặc các đơn này đã được xử lý trước đó."); }
        
        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => "Đã cập nhật thành công {$affected_rows} đơn hàng.", 'consolidated_code' => $consolidated_code]);

    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode(['status' => 'error', 'message' => 'Lỗi xử lý: ' . $e->getMessage()]);
    }
    exit;
}
?>